/**
 * EasyBeans
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: OSGiDeployableImpl.java 5078 2009-07-30 09:28:43Z fornacif $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.ee.deploy.impl.deployable;

import org.ow2.util.archive.api.IArchive;
import org.ow2.util.ee.deploy.api.deployable.OSGiDeployable;

/**
 * Implementation of the OSGi Deployable interface.
 * @author Florent BENOIT
 * @author Francois FORNACIARI
 */
public class OSGiDeployableImpl extends AbsDeployable<OSGiDeployable> implements OSGiDeployable {

    /**
     * True if the bundle must be started (default true).
     */
    private Boolean start = Boolean.TRUE;

    /**
     * True if the bundle must be a referenced JAR file (default false).
     */
    private Boolean reference = Boolean.FALSE;

    /**
     * The bundle start level.
     */
    private Integer startLevel = 1;

    /**
     * True if the bundle start operation is transient.
     * The persistent autostart setting of the bundle is not modified.
     */
    private Boolean startTransient = Boolean.TRUE;

    /**
     * Defines and create an OSGi deployable for the given archive.
     * @param archive the given archive.
     */
    public OSGiDeployableImpl(final IArchive archive) {
        super(archive);
    }

    /**
     * {@inheritDoc}
     */
    public void setStart(final Boolean start) {
        this.start = start;
    }

    /**
     * {@inheritDoc}
     */
    public Boolean isStart() {
        return start;
    }

    /**
     * {@inheritDoc}
     */
    public Boolean isReference() {
        return reference;
    }

    /**
     * {@inheritDoc}
     */
    public void setReference(final Boolean reference) {
        this.reference = reference;
    }

    /**
     * {@inheritDoc}
     */
    public Integer getStartLevel() {
        return startLevel;
    }

    /**
     * {@inheritDoc}
     */
    public void setStartLevel(final Integer startLevel) {
        this.startLevel = startLevel;
    }

    /**
     * {@inheritDoc}
     */
    public Boolean isStartTransient() {
        return startTransient;
    }

    /**
     * {@inheritDoc}
     */
    public void setStartTransient(final Boolean startTransient) {
        this.startTransient = startTransient;
    }

}
