/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: jonas-team@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: IDeploymentReport.java 6234 2012-04-13 14:32:30Z cazauxj $
 * --------------------------------------------------------------------------
 */
package org.ow2.util.ee.deploy.api.report;

import org.ow2.util.ee.deploy.api.deployable.IDeployable;

/**
 * Represents a deployment of a deployable report
 * @author Jeremy Cazaux
 */
public interface IDeploymentReport {

    /**
     * @return the {@link IDeployable} associated to this report
     */
    IDeployable getDeployable();

    /**
     * @return true if the deployment of the associate deployable is ok
     */
    boolean isDeploymentOk();

    /**
     * @return the exception if the deployment of the deployable has failed. Otherwise, return null.
     */
    Exception getException();
}
