/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jonas-team@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: IDeployableHelper.java 5980 2011-09-28 19:07:37Z cazauxj $
 * --------------------------------------------------------------------------
 */
package org.ow2.util.ee.deploy.api.helper;

import org.ow2.util.archive.api.IArchive;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;

/**
 * Component which analyze an archive and build the associated Deployable object.
 * @author Jeremy Cazaux
 */
public interface IDeployableHelper {

    /*
     * Gets the Deployable object for the given URL.
     * @param archive the given archive
     * @return the Deployable object
     * @throws DeployableHelperException if the analyze fails
     */
    public IDeployable<?> getDeployable(final IArchive archive) throws DeployableHelperException;


    /**
     * Gets the Deployable object for the given URL.
     * @param archive the given archive
     * @param isOSGiEnabled if OSGi Deployable can be used
     * @return the Deployable object
     */
    public IDeployable<?> getDeployable(IArchive archive, boolean isOSGiEnabled) throws DeployableHelperException;

}