/**
 * OW2 Util
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: IDeployerManagerCallback.java 4460 2009-01-21 07:37:19Z fornacif $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.ee.deploy.api.deployer;

import org.ow2.util.ee.deploy.api.deployable.IDeployable;

/**
 * Interface defining callbacks executed during deployment/undeployment events.
 * All types of {@IDeployable} are handled.
 * @author Francois Fornaciari
 */
public interface IDeployerManagerCallback {

    /**
     * Method called before deploying the given deployable.
     * @param deployable The deployable to deploy
     */
    void preDeploy(IDeployable<?> deployable);

    /**
     * Method called after having deployed the given deployable.
     * @param deployable The deployable to deploy
     */
    void postDeploy(IDeployable<?> deployable);

    /**
     * Method called before undeploying the given deployable.
     * @param deployable The deployable to undeploy
     */
    void preUndeploy(IDeployable<?> deployable);

    /**
     * Method called after having undeployed the given deployable.
     * @param deployable The deployable to undeploy
     */
    void postUndeploy(IDeployable<?> deployable);
}
