/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: IDeployableMetadataFactory.java 4389 2008-12-15 13:48:57Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.ee.deploy.api.deployable.metadata;

import org.ow2.util.ee.deploy.api.deployable.IDeployable;

/**
 * Interface of a deployable metadata factory.
 * @param <E> deployable type
 * @param <Z> metadata type
 * @author Gael Lalire
 */
public interface IDeployableMetadataFactory<E extends IDeployable<E>, Z extends IDeployableMetadata<E>> {

    /**
     * Class suffix.
     */
    String CLASS_SUFFIX = ".class";

    /**
     * @param deployable the deployable
     * @return the deployable metadata
     * @throws DeployableMetadataException if metadata can not be created
     */
    Z createDeployableMetadata(E deployable) throws DeployableMetadataException;

    /**
     * @param deployable the deployable
     * @param classLoader a classloader to use if a class is not in archive
     * @return the deployable metadata
     * @throws DeployableMetadataException if metadata can not be created
     */
    Z createDeployableMetadata(E deployable, ClassLoader classLoader) throws DeployableMetadataException;

    /**
     * @return the class returned by creation of metadata (eg : EJB3DeployableMetadata.class)
     */
    Class<Z> getDeployableMetadataClass();

}
