/**
 * EasyBeans
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: OSGiDeployable.java 5078 2009-07-30 09:28:43Z fornacif $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.ee.deploy.api.deployable;

/**
 * Represents an OSGi deployable.
 * @author Florent Benoit
 */
public interface OSGiDeployable extends IDeployable<OSGiDeployable> {
    /**
     * Set if the bundle must be started or not.
     * @param start The value to set
     */
    void setStart(final Boolean start);

    /**
     * Return true if the bundle must be started, false otherwise.
     * @return True if the bundle must be started, false otherwise
     */
    Boolean isStart();

    /**
     * Set if the bundle must be a referenced JAR file.
     * @param reference The value to set
     */
    void setReference(final Boolean reference);

    /**
     * Return true if the bundle must be a referenced JAR file.
     * @return True if the bundle must be a referenced JAR file
     */
    Boolean isReference();

    /**
     * Set the bundle start level.
     * @param startLevel The value to set
     */
    void setStartLevel(final Integer startLevel);

    /**
     * Return the bundle start level value.
     * @return The bundle start level value
     */
    Integer getStartLevel();

    /**
     * Set if the bundle start operation is transient.
     * If true, the persistent autostart setting of the bundle is not modified.
     * @param startTransient The value to set
     */
    void setStartTransient(final Boolean startTransient);

    /**
     * Return true if the bundle start operation is transient.
     * @return True if the bundle start operation is transient
     */
    Boolean isStartTransient();

}
