/**
 * EasyBeans
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: IDeployable.java 4389 2008-12-15 13:48:57Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.ee.deploy.api.deployable;

import org.ow2.util.archive.api.IArchive;


/**
 * This interface is used to represent any deployment object that can be used within EasyBeans.<br>
 * The EJB/WEB/RAR/EAR, etc components should extend this interface.
 * @param <T> the type of the deployable.
 * @author Florent Benoit
  */
public interface IDeployable<T extends IDeployable<T>> {

    /**
     * Gets the Archive of this deployable object.
     * @return the archive for this deployable.
     */
    IArchive getArchive();

    /**
     * If the Deployable has been unpacked, return the initial archive.
     * @return the deployable before it is unpacked.
     */
    T getOriginalDeployable();

    /**
     * If the Deployable has been unpacked, return the unpacked deployable.
     * @return the unpacked deployable associated to this deployable.
     */
    T getUnpackedDeployable();

    /**
     * If the Deployable has been unpacked, sets the unpacked deployable.
     * @param unpackedDeployable the unpacked deployable associated to this deployable.
     */
    void setUnpackedDeployable(final T unpackedDeployable);

    /**
     * If the EAR has been unpacked, return the initial archive.
     * @param originalDeployable the deployable before it is unpacked.
     */
    void setOriginalDeployable(final T originalDeployable);

    /**
     * Adds a deployable info that can be used by a deployer.
     * @param extension the implementation of the extension to register.
     */
    void addExtension(final IDeployableInfo extension);

    /**
     * Gets the extension for the given class.
     * @param extensionClass the class to used as a key
     * @return the extension else null if not found.
     */
    IDeployableInfo getExtension(final Class<?  extends IDeployableInfo> extensionClass);

    /**
     * Gets a shorter name for this deployable.
     * @return a shorter name based on the URL.
     */
    String getShortName();

    /**
     * Gets the module name for this deployable.
     * This module name is a name based on the short name but without any extension.
     * @return the module name of this deployable
     */
    String getModuleName();
}
