/**
 * EasyBeans
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: EARDeployable.java 4389 2008-12-15 13:48:57Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.ee.deploy.api.deployable;

import java.net.URL;
import java.util.List;

import org.ow2.util.ee.deploy.api.deployment.ear.IEARInfo;

/**
 * Represents an EAR deployable.
 * @author Florent Benoit
 */
public interface EARDeployable extends IDeployable<EARDeployable> {

    /**
     * @return the list of the EJB deployables for this EAR.
     */
    List<EJBDeployable<?>> getEJBDeployables();

    /**
     * @return the list of the EJB 2.1 deployables for this EAR.
     */
    List<EJB21Deployable> getEJB21Deployables();

    /**
     * @return the list of the EJB 3 deployables for this EAR.
     */
    List<EJB3Deployable> getEJB3Deployables();

    /**
     * @return the list of the War deployables for this EAR.
     */
    List<WARDeployable> getWARDeployables();

    /**
     * @return the list of the Rar deployables for this EAR.
     */
    List<RARDeployable> getRARDeployables();

    /**
     * @return the list of the Car deployables for this EAR.
     */
    List<CARDeployable> getCARDeployables();

    /**
     * @return the list of the Library deployables for this EAR.
     */
    List<LibDeployable> getLibDeployables();

    /**
     * @return the list of the deployables for this EAR.
     */
    List<IDeployable<?>> getAllDeployables();

    /**
     * @return EAR information (of the application.xml file).
     */
    IEARInfo getEARInfo();

    /**
     * @param url  of the wanted deployable
     * @return deployable corresponding to the url
     */
    IDeployable<?> getDeployable(URL url);

    /**
     * @param deployable a module of the EAR
     * @return url of the altDD if present or null if not
     */
    URL getAltDDURL(final IDeployable<?> deployable);

}
