/**
 * OW2 Util
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: IEncodableType.java 5360 2010-02-24 14:29:45Z benoitf $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.auditreport.api;


/**
 * Interface which describing an encodable object.
 * @author Vincent Michaud
 */
public interface IEncodableType<TypeObject> {

    /**
     * Convert an object into a string.
     * @param object The object
     * @return A string representation of the object.
     */
    String toString(final TypeObject object);

    /**
     * Create a new object from a string.
     * @param strObject The string
     * @return The new object
     */
    TypeObject fromString(final String strObject);
}
