/**
 * OW2 Util
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: IDisplayableType.java 5360 2010-02-24 14:29:45Z benoitf $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.auditreport.api;

/**
 * Interface which describing an encodable and displayable object.
 * @author Vincent Michaud
 */
public interface IDisplayableType<TypeObject> extends IEncodableType<TypeObject> {

    /**
     * Convert an encoded string to a displayable string.
     * @param encodedString The encoded string
     * @return A string representation of the object, or a list of string (in
     *         case of array, or complex objects) Each string must not contain
     *         new line characters. Returning a list of string can be used for
     *         this. Also, each string must not begin with a sequence of space.
     */
    Object encodedToDisplayable(final String encodedString);

    /**
     * Convert a displayable string to an encoded string.
     * @param strObject The displayble object. The object can be a string or a
     *        list of string (in case of array, or complex objects). Each string
     *        does not contain new line characters.
     * @return The new object
     */
    String displayableToEncoded(final Object strObject);
}
