/**
 * OW2 Util
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ICurrentInvocationID.java 5630 2010-10-12 15:52:34Z benoitf $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.auditreport.api;


/**
 * Interface used to provide the current ID.
 * @author Florent Benoit
 */
public interface ICurrentInvocationID {

    /**
     * Associates the given audit ID to the current thread.
     * @param auditID the ID to associate to the current thread.
     * @return the previous audit ID.
     */
    IAuditID setAuditID(final IAuditID auditID);

    /**
     * Gets the current audit ID.
     * @return the ID to associate to the current thread
     */
    IAuditID getAuditID();

    /**
     * Initialize a new Audit ID with an optional value.
     * @param id the initial value
     */
    void init(final IAuditID id);

    /**
     * Generate a new ID and return the previously set.
     * @return the previous ID.
     */
    IAuditID newInvocation();

}
