/**
 * OW2 Util
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: IAuditReport.java 5465 2010-04-21 12:31:45Z benoitf $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.auditreport.api;

import java.io.Serializable;

/**
 * Defines the interface for all audit report.
 * @author Florent Benoit
 */
public interface IAuditReport extends Serializable {

    /**
     * Zero value.
     */
    int ZERO = 0;

    /**
     * The value of a Ko.
     */
    double KB = 1024.0;

    /**
     * An empty string.
     */
    String EMPTY_STRING = "";

    /**
     * Value of a nanosecond.
     */
    double NS = 1000000.0;

    /**
     * @return the requestTimeStamp
     */
    long getRequestTimeStamp();

    /**
     * @param requestTimeStamp the requestTimeStamp to set
     */
    void setRequestTimeStamp(final long requestTimeStamp);

    /**
     * @return the current object as a String.
     */
    String toString();
}
