/**
 * OW2 Util
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: IAuditID.java 5630 2010-10-12 15:52:34Z benoitf $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.auditreport.api;

import java.io.Serializable;


/**
 * Defines an ID used to track calls across different components.
 * @author Florent Benoit
 */
public interface IAuditID extends Serializable {

    /**
     * @return the parent ID.
     */
    String getParentID();

    /**
     * @return the full ID.
     */
    String getID();

    /**
     * @return the local ID.
     */
    String getLocalID();

    /**
     * A call is done on this ID, needs to increment.
     */
    void increment();

    /**
     * Generate a new ID.
     */
    void generate();

    /**
     * Sets the parent ID.
     * @param parentID the given parent ID
     */
    void setParentID(final String parentID);

}
