/**
 * OW2 Util
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: AuditorJMXObjectNames.java 5360 2010-02-24 14:29:45Z benoitf $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.auditreport.api;

/**
 * Defines some constants.
 * @author Florent Benoit
 */
public interface AuditorJMXObjectNames {

    /**
     * JMX Name of the EasyBeans auditor component.
     */
    String BASE_AUDIT_COMPONENT = ":type=Auditors";

    /**
     * JMX root Name of the Web auditor component.
     */
    String WEBAUDITOR_TYPE_COMPONENT = BASE_AUDIT_COMPONENT + ",auditorType=web";

    /**
     * JMX root Name of the EJB auditor component.
     */
    String EJBAUDITOR_TYPE_COMPONENT = BASE_AUDIT_COMPONENT + ",auditorType=ejb";

    /**
     * JMX root Name of the JNDI auditor component.
     */
    String JNDIAUDITOR_TYPE_COMPONENT = BASE_AUDIT_COMPONENT + ",auditorType=jndi";

    /**
     * JMX root Name of the Logger auditor component.
     */
    String LOGGERAUDITOR_TYPE_COMPONENT = BASE_AUDIT_COMPONENT + ",auditorType=logger";

}
