/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.asm.commons;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ow2.util.asm.Label;
import org.ow2.util.asm.MethodVisitor;
import org.ow2.util.asm.Opcodes;
import org.ow2.util.asm.commons.JSRInlinerAdapter$Instantiation;
import org.ow2.util.asm.commons.JSRInlinerAdapter$Subroutine;
import org.ow2.util.asm.tree.AbstractInsnNode;
import org.ow2.util.asm.tree.InsnList;
import org.ow2.util.asm.tree.InsnNode;
import org.ow2.util.asm.tree.JumpInsnNode;
import org.ow2.util.asm.tree.LabelNode;
import org.ow2.util.asm.tree.LocalVariableNode;
import org.ow2.util.asm.tree.LookupSwitchInsnNode;
import org.ow2.util.asm.tree.MethodNode;
import org.ow2.util.asm.tree.TableSwitchInsnNode;
import org.ow2.util.asm.tree.TryCatchBlockNode;

public class JSRInlinerAdapter
extends MethodNode
implements Opcodes {
    private final MethodVisitor mv;
    private final Map subroutineHeads = new HashMap();
    private final JSRInlinerAdapter$Subroutine mainSubroutine = new JSRInlinerAdapter$Subroutine();
    private final BitSet dualCitizens = new BitSet();

    public JSRInlinerAdapter(MethodVisitor methodVisitor, int n, String string, String string2, String string3, String[] stringArray) {
        super(n, string, string2, string3, stringArray);
        this.mv = methodVisitor;
    }

    public void visitJumpInsn(int n, Label label) {
        super.visitJumpInsn(n, label);
        LabelNode labelNode = ((JumpInsnNode)this.instructions.getLast()).label;
        if (n == 168 && !this.subroutineHeads.containsKey(labelNode)) {
            this.subroutineHeads.put(labelNode, new JSRInlinerAdapter$Subroutine());
        }
    }

    public void visitEnd() {
        if (!this.subroutineHeads.isEmpty()) {
            this.markSubroutines();
            this.emitCode();
        }
        if (this.mv != null) {
            this.accept(this.mv);
        }
    }

    private void markSubroutines() {
        BitSet bitSet = new BitSet();
        this.markSubroutineWalk(this.mainSubroutine, 0, bitSet);
        Iterator iterator = this.subroutineHeads.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            LabelNode labelNode = (LabelNode)entry.getKey();
            JSRInlinerAdapter$Subroutine jSRInlinerAdapter$Subroutine = (JSRInlinerAdapter$Subroutine)entry.getValue();
            int n = this.instructions.indexOf((AbstractInsnNode)labelNode);
            this.markSubroutineWalk(jSRInlinerAdapter$Subroutine, n, bitSet);
        }
    }

    private void markSubroutineWalk(JSRInlinerAdapter$Subroutine jSRInlinerAdapter$Subroutine, int n, BitSet bitSet) {
        this.markSubroutineWalkDFS(jSRInlinerAdapter$Subroutine, n, bitSet);
        boolean bl = true;
        while (bl) {
            bl = false;
            Iterator iterator = this.tryCatchBlocks.iterator();
            while (iterator.hasNext()) {
                TryCatchBlockNode tryCatchBlockNode = (TryCatchBlockNode)iterator.next();
                int n2 = this.instructions.indexOf((AbstractInsnNode)tryCatchBlockNode.handler);
                if (jSRInlinerAdapter$Subroutine.instructions.get(n2)) continue;
                int n3 = this.instructions.indexOf((AbstractInsnNode)tryCatchBlockNode.start);
                int n4 = this.instructions.indexOf((AbstractInsnNode)tryCatchBlockNode.end);
                int n5 = jSRInlinerAdapter$Subroutine.instructions.nextSetBit(n3);
                if (n5 == -1 || n5 >= n4) continue;
                this.markSubroutineWalkDFS(jSRInlinerAdapter$Subroutine, n2, bitSet);
                bl = true;
            }
        }
    }

    private void markSubroutineWalkDFS(JSRInlinerAdapter$Subroutine jSRInlinerAdapter$Subroutine, int n, BitSet bitSet) {
        while (true) {
            LabelNode labelNode;
            int n2;
            int n3;
            JumpInsnNode jumpInsnNode;
            AbstractInsnNode abstractInsnNode = this.instructions.get(n);
            if (jSRInlinerAdapter$Subroutine.instructions.get(n)) {
                return;
            }
            jSRInlinerAdapter$Subroutine.instructions.set(n);
            if (bitSet.get(n)) {
                this.dualCitizens.set(n);
            }
            bitSet.set(n);
            if (abstractInsnNode.getType() == 6 && abstractInsnNode.getOpcode() != 168) {
                jumpInsnNode = (JumpInsnNode)abstractInsnNode;
                n3 = this.instructions.indexOf((AbstractInsnNode)jumpInsnNode.label);
                this.markSubroutineWalkDFS(jSRInlinerAdapter$Subroutine, n3, bitSet);
            }
            if (abstractInsnNode.getType() == 10) {
                jumpInsnNode = (TableSwitchInsnNode)abstractInsnNode;
                n3 = this.instructions.indexOf((AbstractInsnNode)jumpInsnNode.dflt);
                this.markSubroutineWalkDFS(jSRInlinerAdapter$Subroutine, n3, bitSet);
                for (n2 = jumpInsnNode.labels.size() - 1; n2 >= 0; --n2) {
                    labelNode = (LabelNode)jumpInsnNode.labels.get(n2);
                    n3 = this.instructions.indexOf((AbstractInsnNode)labelNode);
                    this.markSubroutineWalkDFS(jSRInlinerAdapter$Subroutine, n3, bitSet);
                }
            }
            if (abstractInsnNode.getType() == 11) {
                jumpInsnNode = (LookupSwitchInsnNode)abstractInsnNode;
                n3 = this.instructions.indexOf((AbstractInsnNode)jumpInsnNode.dflt);
                this.markSubroutineWalkDFS(jSRInlinerAdapter$Subroutine, n3, bitSet);
                for (n2 = jumpInsnNode.labels.size() - 1; n2 >= 0; --n2) {
                    labelNode = (LabelNode)jumpInsnNode.labels.get(n2);
                    n3 = this.instructions.indexOf((AbstractInsnNode)labelNode);
                    this.markSubroutineWalkDFS(jSRInlinerAdapter$Subroutine, n3, bitSet);
                }
            }
            switch (this.instructions.get(n).getOpcode()) {
                case 167: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    return;
                }
            }
            ++n;
        }
    }

    private void emitCode() {
        LinkedList<JSRInlinerAdapter$Instantiation> linkedList = new LinkedList<JSRInlinerAdapter$Instantiation>();
        linkedList.add(new JSRInlinerAdapter$Instantiation(this, null, this.mainSubroutine, null));
        InsnList insnList = new InsnList();
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        while (!linkedList.isEmpty()) {
            JSRInlinerAdapter$Instantiation jSRInlinerAdapter$Instantiation = (JSRInlinerAdapter$Instantiation)linkedList.removeFirst();
            this.emitSubroutine(jSRInlinerAdapter$Instantiation, linkedList, insnList, arrayList, arrayList2);
        }
        this.instructions = insnList;
        this.tryCatchBlocks = arrayList;
        this.localVariables = arrayList2;
    }

    private void emitSubroutine(JSRInlinerAdapter$Instantiation jSRInlinerAdapter$Instantiation, List list, InsnList insnList, List list2, List list3) {
        LabelNode labelNode;
        JSRInlinerAdapter$Instantiation jSRInlinerAdapter$Instantiation2;
        AbstractInsnNode abstractInsnNode;
        Object object = null;
        int n = this.instructions.size();
        for (int i = 0; i < n; ++i) {
            Object object2;
            abstractInsnNode = this.instructions.get(i);
            jSRInlinerAdapter$Instantiation2 = jSRInlinerAdapter$Instantiation.findOwner(i);
            if (abstractInsnNode.getType() == 7) {
                labelNode = (LabelNode)abstractInsnNode;
                object2 = jSRInlinerAdapter$Instantiation.rangeLabel(labelNode);
                if (object2 == object) continue;
                insnList.add((AbstractInsnNode)object2);
                object = object2;
                continue;
            }
            if (jSRInlinerAdapter$Instantiation2 != jSRInlinerAdapter$Instantiation) continue;
            if (abstractInsnNode.getOpcode() == 169) {
                labelNode = null;
                object2 = jSRInlinerAdapter$Instantiation;
                while (object2 != null) {
                    if (object2.subroutine.ownsInstruction(i)) {
                        labelNode = object2.returnLabel;
                    }
                    object2 = object2.previous;
                }
                if (labelNode == null) {
                    throw new RuntimeException("Instruction #" + i + " is a RET not owned by any subroutine");
                }
                insnList.add((AbstractInsnNode)new JumpInsnNode(167, labelNode));
                continue;
            }
            if (abstractInsnNode.getOpcode() == 168) {
                labelNode = ((JumpInsnNode)abstractInsnNode).label;
                object2 = (JSRInlinerAdapter$Subroutine)this.subroutineHeads.get(labelNode);
                JSRInlinerAdapter$Instantiation jSRInlinerAdapter$Instantiation3 = new JSRInlinerAdapter$Instantiation(this, jSRInlinerAdapter$Instantiation, (JSRInlinerAdapter$Subroutine)object2, null);
                LabelNode labelNode2 = jSRInlinerAdapter$Instantiation3.gotoLabel(labelNode);
                insnList.add((AbstractInsnNode)new InsnNode(1));
                insnList.add((AbstractInsnNode)new JumpInsnNode(167, labelNode2));
                insnList.add((AbstractInsnNode)jSRInlinerAdapter$Instantiation3.returnLabel);
                list.add(jSRInlinerAdapter$Instantiation3);
                continue;
            }
            insnList.add(abstractInsnNode.clone((Map)jSRInlinerAdapter$Instantiation));
        }
        Iterator iterator = this.tryCatchBlocks.iterator();
        while (iterator.hasNext()) {
            TryCatchBlockNode tryCatchBlockNode = (TryCatchBlockNode)iterator.next();
            abstractInsnNode = jSRInlinerAdapter$Instantiation.rangeLabel(tryCatchBlockNode.start);
            if (abstractInsnNode == (jSRInlinerAdapter$Instantiation2 = jSRInlinerAdapter$Instantiation.rangeLabel(tryCatchBlockNode.end))) continue;
            labelNode = jSRInlinerAdapter$Instantiation.gotoLabel(tryCatchBlockNode.handler);
            if (abstractInsnNode == null || jSRInlinerAdapter$Instantiation2 == null || labelNode == null) {
                throw new RuntimeException("Internal error!");
            }
            list2.add(new TryCatchBlockNode((LabelNode)abstractInsnNode, (LabelNode)jSRInlinerAdapter$Instantiation2, labelNode, tryCatchBlockNode.type));
        }
        iterator = this.localVariables.iterator();
        while (iterator.hasNext()) {
            LocalVariableNode localVariableNode = (LocalVariableNode)iterator.next();
            abstractInsnNode = jSRInlinerAdapter$Instantiation.rangeLabel(localVariableNode.start);
            if (abstractInsnNode == (jSRInlinerAdapter$Instantiation2 = jSRInlinerAdapter$Instantiation.rangeLabel(localVariableNode.end))) continue;
            list3.add(new LocalVariableNode(localVariableNode.name, localVariableNode.desc, localVariableNode.signature, (LabelNode)abstractInsnNode, (LabelNode)jSRInlinerAdapter$Instantiation2, localVariableNode.index));
        }
    }

    private static void log(String string) {
        System.err.println(string);
    }

    static /* synthetic */ BitSet access$100(JSRInlinerAdapter jSRInlinerAdapter) {
        return jSRInlinerAdapter.dualCitizens;
    }
}

