/**
 * OW2 Specifications
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Bindable.java 5417 2010-03-24 09:04:14Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.persistence.metamodel;

/**
 * Instances of the type Bindable represent object or attribute types that can be bound into a Path.
 * @param <T> The type of the represented object or attribute
 * @see <a href="http://jcp.org/en/jsr/detail?id=317">JPA 2.0 specification</a>
 * @author Florent Benoit
 * @since JPA 2.0 version.
 */
public interface Bindable<T> {
    
    public static enum BindableType {
        SINGULAR_ATTRIBUTE, PLURAL_ATTRIBUTE, ENTITY_TYPE
    }

    /**
     * Return the bindable type of the represented object.
     * @return bindable type
     */
    BindableType getBindableType();

    /**
     * Return the Java type of the represented object. If the bindable type of the object is PLURAL_ATTRIBUTE, the Java element
     * type is returned. If the bindable type is SINGULAR_ATTRIBUTE or ENTITY_TYPE, the Java type of the represented entity or
     * attribute is returned.
     * @return Java type
     */
    Class<T> getBindableJavaType();
}
