/**
 * OW2 Specifications
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: PrimaryKeyJoinColumn.java 5417 2010-03-24 09:04:14Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.persistence;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * The PrimaryKeyJoinColumn annotation specifies a primary key column that is
 * used as a foreign key to join to another table.<br>
 * The PrimaryKeyJoinColumn annotation is used to join the primary table of an
 * entity subclass in the JOINED mapping strategy to the primary table of its
 * superclass; it is used within a SecondaryTable annotation to join a secondary
 * table to a primary table; and it may be used in a OneToOne mapping in which
 * the primary key of the referencing entity is used as a foreign key to the
 * referenced entity.
 * @see <a href="http://jcp.org/en/jsr/detail?id=317">JPA 2.0 specification</a>
 * @author Florent Benoit
 * @since JPA 1.0 version.
 */
@Target({ TYPE, METHOD, FIELD })
@Retention(RUNTIME)
public @interface PrimaryKeyJoinColumn {

    /**
     * The name of the primary key column of the current table.
     */
    String name() default "";

    /**
     * (Optional) The name of the primary key column of the table being joined
     * to.
     */
    String referencedColumnName() default "";

    /**
     * (Optional) The SQL fragment that is used when generating the DDL for the
     * column. This should not be specified for a OneToOne primary key
     * association.
     */
    String columnDefinition() default "";
}
