/**
 * OW2 Specifications
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: PersistenceException.java 5417 2010-03-24 09:04:14Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.persistence;

/**
 * The PersistenceException is thrown by the persistence provider when a problem
 * occurs. It may be thrown to report that the invoked operation could not
 * complete because of an unexpected error (e.g., failure of the persistence
 * provider to open a database connection). All other exceptions defined by this
 * specification are subclasses of the PersistenceException. All instances of
 * PersistenceException except for instances of NoResultException and
 * NonUniqueResultException will cause the current transaction, if one is
 * active, to be marked for rollback.
 * @see <a href="http://jcp.org/en/jsr/detail?id=317">JPA 2.0 specification</a>
 * @author Florent Benoit
 * @since JPA 1.0 version.
 */
public class PersistenceException extends RuntimeException {

    /**
     * UID for serialization.
     */
    private static final long serialVersionUID = -8734504053550505412L;

    /**
     * Default constructor : builds an exception with an empty message.
     */
    public PersistenceException() {
        super();
    }

    /**
     * Build an exception with the given message.
     * @param message the given message to use.
     */
    public PersistenceException(final String message) {
        super(message);
    }

    /**
     * Build an exception with the given exception.
     * @param causedByThrowable the cause of this exception.
     */
    public PersistenceException(final Throwable causedByThrowable) {
        super(causedByThrowable);
    }

    /**
     * Builds an exception with a given message and given exception.
     * @param message the message of this exception.
     * @param causedByThrowable the cause of this exception.
     */
    public PersistenceException(final String message, final Throwable causedByThrowable) {
        super(message, causedByThrowable);
    }

}
