/**
 * OW2 Specifications
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: MapKeyJoinColumn.java 5417 2010-03-24 09:04:14Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.persistence;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * The MapKeyJoinColumn annotation is used to specify a mapping to an entity that is a map key. The map key join column is in the
 * collection table, join table, or table of the target entity that is used to rep- resent the map.
 * @see <a href="http://jcp.org/en/jsr/detail?id=317">JPA 2.0 specification</a>
 * @author Florent Benoit
 * @since JPA 2.0 version.
 */
@Target({ METHOD, FIELD })
@Retention(RUNTIME)
public @interface MapKeyJoinColumn {

    /**
     * (Optional) The name of the foreign key column for the map key. The table in which it is found depends upon the con- text.
     * If the join is for a map key for an element collection, the foreign key col- umn is in the collection table for the map
     * value. If the join is for a map key for a ManyToMany entity relationship or for a OneToMany entity relationship using a
     * join table, the foreign key column is in a join table. If the join is for a OneToMany entity relationship using a foreign
     * key mapping strategy, the foreign key col- umn for the map key is in the table of the entity that is the value of the map.
     **/
    String name() default "";

    /**
     * (Optional) The name of the column ref- erenced by this foreign key column. The referenced column is in the table of the
     * target entity.
     **/
    String referencedColumnName() default "";

    /**
     * (Optional) Whether the property is a unique key. This is a shortcut for the UniqueConstraint annotation at the table level
     * and is useful for when the unique key constraint is only a single field.
     **/
    boolean unique() default false;

    /**
     * (Optional) Whether the foreign key col- umn is nullable.
     **/
    boolean nullable() default false;

    /**
     * (Optional) Whether the column is included in SQL INSERT statements generated by the persistence provider.
     **/
    boolean insertable() default true;

    /**
     * (Optional) Whether the column is included in SQL UPDATE statements generated by the persistence provider.
     **/
    boolean updatable() default true;

    /**
     * (Optional) The SQL fragment that is used when generating the DDL for the column.
     **/
    String columnDefinition() default "";

    /**
     * (Optional) The name of the table that contains the foreign key column. If the join is for a map key for an element col-
     * lection, the foreign key column is in the collection table for the map value. If the join is for a map key for a ManyToMany
     * entity relationship or for a OneToMany entity relationship using a join table, the foreign key column is in a join table.
     * If the join is for a OneToMany entity rela- tionship using a foreign key mapping strategy, the foreign key column for the
     * map key is in the table of the entity that is the value of the map.
     **/
    String table() default "";

}
