/**
 * OW2 Specifications
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Basic.java 5417 2010-03-24 09:04:14Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.persistence;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;
import static javax.persistence.FetchType.EAGER;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * The Basic annotation is the simplest type of mapping to a database column.
 * The Basic annotation can be applied to a persistent property or instance
 * variable of any of the following types: Java primitive types, wrappers of the
 * primitive types, java.lang.String, java.math.BigInteger,
 * java.math.BigDecimal, java.util.Date, java.util.Calendar, java.sql.Date,
 * java.sql.Time, java.sql.Timestamp, byte[], Byte[], char[], Character[],
 * enums, and any other type that implements Serializable.
 * @see <a href="http://jcp.org/en/jsr/detail?id=317">JPA 2.0 specification</a>
 * @author Florent Benoit
 * @since JPA 1.0 version.
 */
@Target({ METHOD, FIELD })
@Retention(RUNTIME)
public @interface Basic {

    /**
     * (Optional) Whether the value of the field or property should be lazily
     * loaded or must be eagerly fetched. The EAGER strategy is a requirement on
     * the persistence provider runtime that the value must be eagerly fetched.
     * The LAZY strategy is a hint to the persistence provider runtime.
     */
    FetchType fetch() default EAGER;

    /**
     * (Optional) Whether the value of the field or property may be null. This
     * is a hint and is disregarded for primitive types; it may be used in
     * schema generation.
     */
    boolean optional() default true;
}
