/**
 * EasyBeans
 * Copyright (C) 2006 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: PersistenceProvider.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.persistence.spi;

import java.util.Map;

import javax.persistence.EntityManagerFactory;

/**
 * Interface implemented by the persistence provider.<br>
 * This interface is used to create an EntityManagerFactory.<br>
 * It is invoked by the container in Java EE environments and by the Persistence
 * class in Java SE environments.
 * @see <a href="http://www.jcp.org/en/jsr/detail?id=220">EJB 3.0 specification</a>
 * @author Florent Benoit
 * @since EJB 3.0 version.
 */
public interface PersistenceProvider {
    /**
     * Called by Persistence class when an EntityManagerFactory is to be
     * created.
     * @param emName The name of the persistence unit
     * @param map A Map of properties for use by the persistence provider. These
     *        properties may be used to override the values of the corresponding
     *        elements in the persistence.xml file or specify values for
     *        properties not specified in the persistence.xml (and may be null
     *        if no properties are specified).
     * @return EntityManagerFactory for the persistence unit, or null if the
     *         provider is not the right provider
     */
    EntityManagerFactory createEntityManagerFactory(String emName, Map map);

    /**
     * Called by the container when an EntityManagerFactory is to be created.
     * @param info Metadata for use by the persistence provider
     * @return EntityManagerFactory for the persistence unit specified by the
     *         metadata
     * @param map A Map of integration-level properties for use by the
     *        persistence provider (may be null if no properties are specified).
     */
    EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map map);
}
