/**
 * EasyBeans
 * Copyright (C) 2006 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: SequenceGenerator.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.persistence;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * The SequenceGenerator annotation defines a primary key generator that may be
 * referenced by name when a generator element is specified for the
 * GeneratedValue annotation. A sequence generator may be specified on the
 * entity class or on the primary key field or property. The scope of the
 * generator name is global to the persistence unit (across all generator
 * types).
 * @see <a href="http://www.jcp.org/en/jsr/detail?id=220">EJB 3.0 specification</a>
 * @author Florent Benoit
 * @since EJB 3.0 version.
 */
@Target({ TYPE, METHOD, FIELD })
@Retention(RUNTIME)
public @interface SequenceGenerator {

    /**
     * (Required) A unique generator name that can be referenced by one or more
     * classes to be the generator for primary key values.
     */
    String name();

    /**
     * (Optional) The name of the database sequence object from which to obtain
     * primary key values.
     */
    String sequenceName() default "";

    /**
     * (Optional) The value from which the sequence object is to start
     * generating.
     */
    int initialValue() default 1;

    /**
     * (Optional) The amount to increment by when allocating sequence numbers
     * from the sequence.
     */
    int allocationSize() default 50;
}
