/**
 * EasyBeans
 * Copyright (C) 2006 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: SecondaryTable.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.persistence;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * The SecondaryTable annotation is used to specify a secondary table for the
 * annotated entity class. Specifying one or more secondary tables indicates
 * that the data for the entity class is stored across multiple tables.
 * @see <a href="http://www.jcp.org/en/jsr/detail?id=220">EJB 3.0 specification</a>
 * @author Florent Benoit
 * @since EJB 3.0 version.
 */
@Target(TYPE)
@Retention(RUNTIME)
public @interface SecondaryTable {

    /**
     * (Required) The name of the table.
     */
    String name();

    /**
     * (Optional) The catalog of the table.
     */
    String catalog() default "";

    /**
     * (Optional) The schema of the table.
     */
    String schema() default "";

    /**
     * (Optional) The columns that are used to join with the primary table.
     */
    PrimaryKeyJoinColumn[] pkJoinColumns() default {};

    /**
     * (Optional) Unique constraints that are to be placed on the table. These
     * are typically only used if table generation is in effect. These
     * constraints apply in addition to any constraints specified by the Column
     * and Join- Column annotations and constraints entailed by primary key
     * mappings.
     */
    UniqueConstraint[] uniqueConstraints() default {};
}
