/**
 * EasyBeans
 * Copyright (C) 2006 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: GenerationType.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.persistence;

/**
 * Enumeration of the types of primary key generation.
 * @see <a href="http://www.jcp.org/en/jsr/detail?id=220">EJB 3.0 specification</a>
 * @author Florent Benoit
 * @since EJB 3.0 version.
 */
public enum GenerationType {

    /**
     * The TABLE generator type value indicates that the persistence provider
     * must assign primary keys for the entity using an underlying database
     * table to ensure uniqueness.
     */
    TABLE,

    /**
     * The SEQUENCE and IDENTITY values specify the use of a database sequence
     * or identity column, respectively.
     */
    SEQUENCE,

    /**
     * The SEQUENCE and IDENTITY values specify the use of a database sequence
     * or identity column, respectively.
     */
    IDENTITY,

    /**
     * The AUTO value indicates that the persistence provider should pick an
     * appropriate strategy for the particular database. The AUTO generation
     * strategy may expect a database resource to exist, or it may attempt to
     * create one. A vendor may provide documentation on how to create such
     * resources in the event that it does not support schema generation or
     * cannot create the schema resource at runtime.
     */
    AUTO
}
