/**
 * EasyBeans
 * Copyright (C) 2006 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: EntityManagerFactory.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.persistence;

import java.util.Map;

/**
 * Factory of EntityManager.
 * @see <a href="http://www.jcp.org/en/jsr/detail?id=220">EJB 3.0 specification</a>
 * @author Florent Benoit
 * @since EJB 3.0 version.
 */
public interface EntityManagerFactory {
    /**
     * Create a new EntityManager. This method returns a new EntityManager
     * instance each time it is invoked. The isOpen method will return true on
     * the returned instance.
     * @return a new EntityManager instance each time it is invoked.
     */
    EntityManager createEntityManager();

    /**
     * Create a new EntityManager with the specified Map of properties. This
     * method returns a new EntityManager instance each time it is invoked. The
     * isOpen method will return true on the returned instance.
     * @param map the given map of properties.
     * @return a new EntityManager instance each time it is invoked.
     */
    EntityManager createEntityManager(final Map map);

    /**
     * Close the factory, releasing any resources that it holds. After a factory
     * instance is closed, all methods invoked on it will throw an
     * IllegalStateException, except for isOpen, which will return false. Once
     * an EntityManagerFactory has been closed, all its entity managers are
     * considered to be in the closed state.
     */
    void close();

    /**
     * Indicates whether the factory is open.
     * @return true until the factory has been closed.
     */
    boolean isOpen();
}
