/**
 * EasyBeans
 * Copyright (C) 2006 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DiscriminatorValue.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.persistence;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * The DiscriminatorValue annotation is used to specify the value of the
 * discriminator column for entities of the given type. The DiscriminatorValue
 * annotation can only be specified on a concrete entity class. If the
 * DiscriminatorValue annotation is not specified and a discriminator column is
 * used, a provider-specific function will be used to generate a value
 * representing the entity type.<br>
 * The inheritance strategy and the discriminator column are only specified in
 * the root of an entity class hierarchy or subhierarchy in which a different
 * inheritance strategy is applied. The discriminator value, if not defaulted,
 * should be specified for each entity class in the hierarchy.
 * @see <a href="http://www.jcp.org/en/jsr/detail?id=220">EJB 3.0 specification</a>
 * @author Florent Benoit
 * @since EJB 3.0 version.
 */
@Target(TYPE)
@Retention(RUNTIME)
public @interface DiscriminatorValue {

    /**
     * (Optional) The value that indicates that the row is an entity of the
     * annotated entity type.
     */
    String value();

}
