/**
 * EasyBeans
 * Copyright (C) 2006 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: AttributeOverride.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.persistence;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * The AttributeOverride annotation is used to override the mapping of a Basic
 * (whether explicit or default) property or field or Id property or field.<br>
 * The AttributeOverride annotation may be applied to an entity that extends a
 * mapped superclass or to an embedded field or property to override a basic
 * mapping defined by the mapped superclass or embeddable class. If the
 * AttributeOverride annotation is not specified, the column is mapped the same
 * as in the original mapping.
 * @see <a href="http://www.jcp.org/en/jsr/detail?id=220">EJB 3.0 specification</a>
 * @author Florent Benoit
 * @since EJB 3.0 version.
 */
@Target({ TYPE, METHOD, FIELD })
@Retention(RUNTIME)
public @interface AttributeOverride {

    /**
     * (Required) The name of the property whose mapping is being overridden if
     * property-based access is being used, or the name of the field if
     * field-based access is used.
     */
    String name();

    /**
     * (Required) The column that is being mapped to the persistent attribute.
     * The mapping type will remain the same as is defined in the embeddable
     * class or mapped superclass.
     */
    Column column();
}
