/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ValidatingManagedConnectionFactory.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi;

import java.util.Set;

import javax.resource.ResourceException;

/**
 * This interface is implemented by a ManagedConnectionFactory instance
 * that supports the ability to validate ManagedConnection objects.<br/>
 * 
 * This may be used by the application server to prune invalid
 * ManagedConnection objects from its connection pool.
 * @version 1.0
 * @author Guillaume Sauthier
 */
public interface ValidatingManagedConnectionFactory {
 
    /**
     * This method returns a set of invalid ManagedConnection objects
     * chosen from a specified set of ManagedConnection  objects.
     * @param connectionSet a set of ManagedConnection objects that need
     *        to be validated.
     * @return a set of invalid ManagedConnection objects.
     * @throws ResourceException generic exception.
     */
    Set getInvalidConnections(Set connectionSet) throws ResourceException;
}
