/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: EISSystemException.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi;

import javax.resource.ResourceException;
 
/**
 * @author Guillaume Sauthier
 */
public class EISSystemException extends ResourceException {

    /**
     * Serial version UID.
     */
    private static final long serialVersionUID = 5753172122428814004L;

    /**
     * {@inheritDoc}
     */
    public EISSystemException() {
    }

    /**
     * {@inheritDoc}
     */
    public EISSystemException(String message) {
        super(message);
    }

    /**
     * {@inheritDoc}
     */
    public EISSystemException(Throwable cause) {
        super(cause);
    }

    /**
     * {@inheritDoc}
     */
    public EISSystemException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * {@inheritDoc}
     */
    public EISSystemException(String message, String errorCode) {
        super(message, errorCode);
    }

}
