/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ConnectionEventListener.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi;
 
import java.util.EventListener;

/**
 * The ConnectionEventListener interface provides an event callback
 * mechanism to enable an application server to receive notifications
 * from a ManagedConnection instance.<br/>
 * 
 * An application server uses these event notifications to manage its
 * connection pool, to clean up any invalid or terminated connections
 * and to manage local transactions.<br/>
 * 
 * An application server implements the ConnectionEventListener
 * interface. It registers a connection listener with a ManagedConnection
 * instance by using ManagedConnection.addConnectionEventListener method.
 * @version 0.5
 * @author Guillaume Sauthier
 */
public interface ConnectionEventListener extends EventListener {

    /**
     * Notifies that an application component has closed the connection.<br/>
     * 
     * A ManagedConnection instance notifies its registered set of
     * listeners by calling ConnectionEventListener.connectionClosed
     * method when an application component closes a connection handle.
     * The application server uses this connection close event to put
     * the ManagedConnection instance back in to the connection pool. 
     * @param event event object describing the source of the event
     */
    void connectionClosed(ConnectionEvent event);
    
    /**
     * Notifies that a Resource Manager Local Transaction was started
     * on the ManagedConnection instance.
     * @param event event object describing the source of the event
     */
    void localTransactionStarted(ConnectionEvent event);
    
    /**
     * Notifies that a Resource Manager Local Transaction was
     * committed on the ManagedConnection instance.
     * @param event event object describing the source of the event
     */
    void localTransactionCommitted(ConnectionEvent event);
    
    /**
     * Notifies that a Resource Manager Local Transaction was
     * rolled back on the ManagedConnection instance.
     * @param event event object describing the source of the event
     */
    void localTransactionRolledback(ConnectionEvent event);
    
    /**
     * Notifies a connection related error. The ManagedConnection
     * instance calls the method ConnectionEventListener.connectionErrorOccurred
     * to notify its registered listeners of the occurrence of a physical
     * connection-related error. The event notification happens just before
     * a resource adapter throws an exception to the application component
     * using the connection handle. The connectionErrorOccurred method
     * indicates that the associated ManagedConnection instance is now
     * invalid and unusable. The application server handles the connection
     * error event notification by initiating application server-specific
     * cleanup (for example, removing ManagedConnection instance from the
     * connection pool) and then calling ManagedConnection.destroy method to
     * destroy the physical connection.
     * @param event event object describing the source of the event
     */
    void connectionErrorOccurred(ConnectionEvent event);
}
