/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: BootstrapContext.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */
 
package javax.resource.spi;

import java.util.Timer;

import javax.resource.spi.work.WorkManager;

/**
 * This provides a mechanism to pass a bootstrap context to a
 * resource adapter instance when it is bootstrapped. That is,
 * when (start(BootstrapContext)) method on the ResourceAdapter
 * class is invoked. The bootstrap context contains references
 * to useful facilities that could be used by the resource
 * adapter instance.
 * @version 1.0
 * @author Guillaume Sauthier
 */
public interface BootstrapContext {

    /**
     * Provides a handle to a WorkManager instance. The WorkManager
     * instance could be used by a resource adapter to do its work
     * by submitting Work instances for execution.
     * @return a WorkManager instance.
     */
    WorkManager getWorkManager();
    
    /**
     * Provides a handle to a XATerminator instance. The XATerminator
     * instance could be used by a resource adapter to flow-in
     * transaction completion and crash recovery calls from an EIS.
     * @return a XATerminator instance.
     */
    XATerminator getXATerminator();
    
    /**
     * Creates a new java.util.Timer instance. The Timer instance
     * could be used to perform periodic Work executions or other tasks.
     * @return a new Timer instance.
     * @throws UnavailableException indicates that a Timer instance is
     *         not available. The request may be retried later.
     */
    Timer createTimer()throws UnavailableException;
}
