/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ResourceWarning.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.resource.cci;
 
import javax.resource.ResourceException;

/**
 * A ResourceWarning provides information on warnings related to execution
 * of an interaction with an EIS. Warnings are silently chained to the
 * object whose method caused it to be reported.
 * @author Guillaume Sauthier
 */
public class ResourceWarning extends ResourceException {

    /**
     * Serial version UID.
     */
    private static final long serialVersionUID = 1233859030030360576L;

    /**
     * Constructs a new instance with null as its detail message.
     */
    public ResourceWarning() {
        super();
    }

    /**
     * Constructs a new throwable with the specified detail message
     * and an error code.
     * @param message a description of the exception.
     * @param errorCode a string specifying the vendor specific error code.
     */
    public ResourceWarning(String message, String errorCode) {
        super(message, errorCode);
    }

    /**
     * Constructs a new throwable with the specified detail message and cause.
     * @param message the detail message.
     * @param cause a chained exception of type Throwable.
     */
    public ResourceWarning(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructs a new instance with the specified detail message.
     * @param message the detail message.
     */
    public ResourceWarning(String message) {
        super(message);
    }

    /**
     * Constructs a new throwable with the specified cause.
     * @param cause a chained exception of type Throwable.
     */
    public ResourceWarning(Throwable cause) {
        super(cause);
    }

    /**
     * Throw an {@link IllegalStateException}.
     * @deprecated
     */
    public ResourceWarning getLinkedWarning() {
        throw new IllegalStateException("Deprecated");
    }
    
    /**
     * Throw an {@link IllegalStateException}.
     * @deprecated
     */
    public void setLinkedWarning(ResourceWarning warning) {
        throw new IllegalStateException("Deprecated");
    }
}
