/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: RecordFactory.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.resource.cci;
 
import javax.resource.ResourceException;

/**
 * The RecordFactory interface is used for creating MappedRecord and
 * IndexedRecord instances. Note that the RecordFactory is only used
 * for creation of generic record instances. A CCI implementation
 * provides an implementation class for the RecordFactory interface.
 * @since 0.8
 * @author Guillaume Sauthier
 */
public interface RecordFactory {

    /**
     * Creates a MappedRecord. The method takes the name of the record
     * that is to be created by the RecordFactory. The name of the
     * record acts as a pointer to the meta information (stored in
     * the metadata repository) for a specific record type.
     * @param recordName Name of the Record
     * @return MappedRecord 
     * @throws ResourceException Failed to create a MappedRecord. Example
     *         error cases are:<ul>
     *         <li>Invalid specification of record name</li>
     *         <li>Resource adapter internal error</li>
     *         <li>Failed to access metadata repository</li>
     *         </ul>
     * @throws NotSupportedException Operation not supported
     */
    MappedRecord createMappedRecord(String recordName) throws ResourceException;
    
    /**
     * Creates a IndexedRecord. The method takes the name of the record
     * that is to be created by the RecordFactory. The name of the record
     * acts as a pointer to the meta information (stored in the metadata
     * repository) for a specific record type.
     * @param recordName Name of the Record
     * @return IndexedRecord 
     * @throws ResourceException  Failed to create a MappedRecord. Example
     *         error cases are:<ul>
     *         <li>Invalid specification of record name</li>
     *         <li>Resource adapter internal error</li>
     *         <li>Failed to access metadata repository</li>
     *         </ul>
     * @throws NotSupportedException Operation not supported
     */
    IndexedRecord createIndexedRecord(String recordName) throws ResourceException;
}
