/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: InteractionSpec.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.resource.cci;

import java.io.Serializable;
 
/**
 * An InteractionSpec holds properties for driving an Interaction with
 * an EIS instance. An InteractionSpec is used by an Interaction to execute
 * the specified function on an underlying EIS.<br/>
 * 
 * The CCI specification defines a set of standard properties for an
 * InteractionSpec. An InteractionSpec implementation is not required
 * to support a standard property if that property does not apply to
 * its underlying EIS.<br/>
 * 
 * The InteractionSpec implementation class must provide getter and
 * setter methods for each of its supported properties. The getter
 * and setter methods convention should be based on the Java Beans
 * design pattern.<br/>
 * 
 * The standard properties are as follows:
 * <ul>
 *   <li>FunctionName: name of an EIS function</li>
 *   <li>InteractionVerb: mode of interaction with an EIS instance:
 *   SYNC_SEND, SYNC_SEND_RECEIVE, SYNC_RECEIVE</li>
 *   <li>ExecutionTimeout: the number of milliseconds an Interaction
 *   will wait for an EIS to execute the specified function</li>
 * </ul>
 * 
 * The following standard properties are used to give hints to an
 * Interaction instance about the ResultSet requirements:
 * <ul>
 *   <li>FetchSize</li>
 *   <li>FetchDirection</li>
 *   <li>MaxFieldSize</li>
 *   <li>ResultSetType</li>
 *   <li>ResultSetConcurrency</li>
 * </ul>
 * 
 * A CCI implementation can provide additional properties beyond that
 * described in the InteractionSpec interface. Note that the format
 * and type of the additional properties is specific to an EIS and is
 * outside the scope of the CCI specification.<br/>
 * 
 * It is required that the InteractionSpec interface be implemented as
 * a JavaBean for the toolability support. The properties on the
 * InteractionSpec implementation class should be defined through
 * the getter and setter methods pattern. An implementation class for
 * InteractionSpec interface is required to implement the java.io.Serializable
 * interface.
 * @since 0.8
 * @version 0.8
 * @author Guillaume Sauthier
 */
public interface InteractionSpec extends Serializable {

    /**
     * Interaction Verb type: The execution of an Interaction does only a
     * send to the target EIS instance. The input record is sent to the
     * EIS instance without any synchronous response in terms of an output
     * Record or ResultSet.
     */
    static final int SYNC_SEND = 0;
    
    /**
     * Interaction Verb type: The execution of an Interaction sends a
     * request to the EIS instance and receives response synchronously.
     * The input record is sent to the EIS instance with the output received
     * either as Record or CCIResultSet.
     */
    static final int SYNC_SEND_RECEIVE = 1;
    
    /**
     * The execution of an Interaction results in a synchronous receive
     * of an output Record. An example is: a session bean gets a method
     * invocation and it uses this SEND_RECEIVE form of interaction to
     * retrieve messages that have been delivered to a message queue.
     */
    static final int SYNC_RECEIVE = 2;
}
