/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Referenceable.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.resource;

import javax.naming.Reference;

/**
 * The Referenceable interface extends the javax.naming.Referenceable
 * interface. It enables support for JNDI Reference mechanism for the
 * registration of the connection factory in the JNDI name space. Note
 * that the implementation and structure of Reference is specific to
 * an application server.<br/>
 *
 * The implementation class for a connection factory interface is
 * required to implement both java.io.Serializable and
 * javax.resource.Referenceable interfaces to support JNDI registration.
 * @author Guillaume Sauthier
 */
public interface Referenceable extends javax.naming.Referenceable {

    /**
     * Sets the Reference instance. This method is called by the deployment
     * code to set the Reference that can be later returned by the getReference
     * method (as defined in the javax.naming.Referenceable interface).
     * @param reference A Reference instance
     * @see javax.naming.Referenceable.getReference()
     */
    void setReference(Reference reference);
}
