/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.job.programming;

import java.security.KeyException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;
import org.objectweb.proactive.annotation.PublicAPI;
import org.objectweb.proactive.api.PAActiveObject;
import org.objectweb.proactive.core.ProActiveException;
import org.objectweb.proactive.core.UniqueID;
import org.objectweb.proactive.core.node.Node;
import org.objectweb.proactive.core.util.log.ProActiveLogger;
import org.objectweb.proactive.gcmdeployment.GCMVirtualNode;
import org.ow2.proactive.authentication.crypto.CredData;
import org.ow2.proactive.authentication.crypto.Credentials;
import org.ow2.proactive.scheduler.common.Scheduler;
import org.ow2.proactive.scheduler.common.SchedulerAuthenticationInterface;
import org.ow2.proactive.scheduler.common.SchedulerConnection;
import org.ow2.proactive.scheduler.common.exception.AlreadyConnectedException;
import org.ow2.proactive.scheduler.common.exception.ConnectionException;
import org.ow2.proactive.scheduler.job.programming.GCMVirtualNodeImpl;
import org.ow2.proactive.scheduler.job.programming.NodeProviderException;
import org.ow2.proactive.scheduler.job.programming.NodeProviderJob;
import org.ow2.proactive.scheduler.job.programming.NodeProviderRegistry;

@PublicAPI
public class SchedulerNodeProvider {
    private static final Logger logger = ProActiveLogger.getLogger(SchedulerNodeProvider.class);
    private static final String NODES_AQUISITION_TIMEOUT_PROPERTY = "scheduler.node.provider.timeout";
    private static final int DEFAULT_NODES_AQUISITION_TIMEOUT = 600000;
    private final NodeProviderRegistry registry = (NodeProviderRegistry)PAActiveObject.newActive((String)NodeProviderRegistry.class.getName(), (Object[])new Object[0]);
    private final Map<String, Scheduler> schedulers;
    private final Map<UniqueID, NodeProviderJob> nodeProviderJobs;
    private final int nodesAquisitionTimeout;

    public SchedulerNodeProvider() throws ProActiveException {
        PAActiveObject.registerByName((Object)this.registry, (String)("NODE_PROVIDER_REGISTRY_" + new UniqueID().getCanonString()));
        this.schedulers = new HashMap<String, Scheduler>();
        this.nodeProviderJobs = new HashMap<UniqueID, NodeProviderJob>();
        this.nodesAquisitionTimeout = System.getProperty(NODES_AQUISITION_TIMEOUT_PROPERTY) != null ? Integer.parseInt(System.getProperty(NODES_AQUISITION_TIMEOUT_PROPERTY)) : 600000;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                SchedulerNodeProvider.this.releaseAllNodes();
            }
        });
    }

    public UniqueID submitNodeRequest(String schedulerURL, String username, String password, int numberNodes, String dataFolder) throws NodeProviderException {
        return this.submitNodeRequest(schedulerURL, username, password, numberNodes, dataFolder, (List<String>)null, (String[])null);
    }

    public UniqueID submitNodeRequest(String schedulerURL, String username, String password, int numberNodes, String dataFolder, List<String> jvmArguments) throws NodeProviderException {
        return this.submitNodeRequest(this.connectToScheduler(schedulerURL, username, password), numberNodes, dataFolder, jvmArguments, new String[0]);
    }

    public UniqueID submitNodeRequest(String schedulerURL, String username, String password, int numberNodes, String dataFolder, String ... nodeSourceNames) throws NodeProviderException {
        return this.submitNodeRequest(this.connectToScheduler(schedulerURL, username, password), numberNodes, dataFolder, null, nodeSourceNames);
    }

    public UniqueID submitNodeRequest(String schedulerURL, String username, String password, int numberNodes, String dataFolder, List<String> jvmArguments, String ... nodeSourceNames) throws NodeProviderException {
        return this.submitNodeRequest(this.connectToScheduler(schedulerURL, username, password), numberNodes, dataFolder, jvmArguments, nodeSourceNames);
    }

    public UniqueID submitNodeRequest(String schedulerURL, String credentialsPath, int numberNodes, String dataFolder) throws NodeProviderException {
        return this.submitNodeRequest(schedulerURL, credentialsPath, numberNodes, dataFolder, (List<String>)null, (String[])null);
    }

    public UniqueID submitNodeRequest(String schedulerURL, String credentialsPath, int numberNodes, String dataFolder, List<String> jvmArguments) throws NodeProviderException {
        return this.submitNodeRequest(schedulerURL, credentialsPath, numberNodes, dataFolder, jvmArguments, new String[0]);
    }

    public UniqueID submitNodeRequest(String schedulerURL, String credentialsPath, int numberNodes, String dataFolder, String ... nodeSourceNames) throws NodeProviderException {
        return this.submitNodeRequest(schedulerURL, credentialsPath, numberNodes, dataFolder, (List<String>)null, nodeSourceNames);
    }

    public UniqueID submitNodeRequest(String schedulerURL, String credentialsPath, int numberNodes, String dataFolder, List<String> jvmArguments, String ... nodeSourceNames) throws NodeProviderException {
        return this.submitNodeRequest(this.connectToScheduler(schedulerURL, credentialsPath), numberNodes, dataFolder, jvmArguments, nodeSourceNames);
    }

    private synchronized Scheduler connectToScheduler(String schedulerURL, String username, String password) throws NodeProviderException {
        if (this.schedulers.containsKey(schedulerURL)) {
            return this.schedulers.get(schedulerURL);
        }
        try {
            SchedulerAuthenticationInterface sai = SchedulerConnection.join((String)schedulerURL);
            PublicKey pk = sai.getPublicKey();
            Scheduler scheduler = null;
            if (pk == null) {
                pk = Credentials.getPublicKey((String)Credentials.getPubKeyPath());
            }
            if (pk == null) {
                throw new KeyException("No public key found, cannot connect to Scheduler located at " + schedulerURL);
            }
            scheduler = sai.login(Credentials.createCredentials((CredData)new CredData(username, password), (PublicKey)pk));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Connected to Scheduler " + schedulerURL));
            }
            this.schedulers.put(schedulerURL, scheduler);
            return scheduler;
        }
        catch (ConnectionException ce) {
            throw new NodeProviderException(ce);
        }
        catch (LoginException le) {
            throw new NodeProviderException(le);
        }
        catch (AlreadyConnectedException ace) {
            throw new NodeProviderException(ace);
        }
        catch (KeyException ke) {
            throw new NodeProviderException(ke);
        }
    }

    private Scheduler connectToScheduler(String schedulerURL, String credentialsPath) throws NodeProviderException {
        if (this.schedulers.containsKey(schedulerURL)) {
            return this.schedulers.get(schedulerURL);
        }
        try {
            SchedulerAuthenticationInterface sai = SchedulerConnection.join((String)schedulerURL);
            Scheduler scheduler = sai.login(Credentials.getCredentials((String)credentialsPath));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Connected to Scheduler " + schedulerURL));
            }
            this.schedulers.put(schedulerURL, scheduler);
            return scheduler;
        }
        catch (ConnectionException ce) {
            throw new NodeProviderException(ce);
        }
        catch (LoginException le) {
            throw new NodeProviderException(le);
        }
        catch (AlreadyConnectedException ace) {
            throw new NodeProviderException(ace);
        }
        catch (KeyException ke) {
            throw new NodeProviderException(ke);
        }
    }

    private UniqueID submitNodeRequest(Scheduler scheduler, int nbNodes, String dataFolder, List<String> jvmArguments, String ... nodeSourceNames) throws NodeProviderException {
        UniqueID nodeRequestID = new UniqueID();
        this.registry.addNodeRequest(nodeRequestID, nbNodes);
        NodeProviderJob nodeProviderJob = new NodeProviderJob(nodeRequestID, scheduler, nbNodes, dataFolder, jvmArguments, this.registry.getURL(), nodeSourceNames);
        this.nodeProviderJobs.put(nodeRequestID, nodeProviderJob);
        return nodeRequestID;
    }

    private List<Node> getNodes(UniqueID nodeRequestID) throws NodeProviderException {
        if (this.nodeProviderJobs.containsKey(nodeRequestID)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Waiting for the acquisition of nodes for request #" + nodeRequestID));
            }
            long startTime = System.currentTimeMillis();
            while (!this.registry.isDeploymentFinished(nodeRequestID)) {
                try {
                    if (System.currentTimeMillis() > startTime + (long)this.nodesAquisitionTimeout) {
                        logger.error((Object)("Unsuccessful acquisition of nodes for node request #" + nodeRequestID + " after " + this.nodesAquisitionTimeout + " ms"));
                        this.releaseNodes(nodeRequestID);
                        return new ArrayList<Node>();
                    }
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    this.releaseNodes(nodeRequestID);
                    throw new NodeProviderException(ie);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Acquisition of nodes for node request #" + nodeRequestID + " completed"));
            }
            return this.registry.getNodes(nodeRequestID);
        }
        logger.error((Object)("No such node request ID: #" + nodeRequestID));
        return new ArrayList<Node>();
    }

    public List<Node> getNodes(UniqueID ... nodeRequestIDs) throws NodeProviderException {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (UniqueID nodeRequestID : nodeRequestIDs) {
            nodes.addAll(this.getNodes(nodeRequestID));
        }
        return nodes;
    }

    public GCMVirtualNode getGCMVirtualNode(String vnName, UniqueID ... nodeRequestIDs) throws NodeProviderException {
        return new GCMVirtualNodeImpl(vnName, this.getNodes(nodeRequestIDs));
    }

    public void releaseNodes(UniqueID nodeRequestID) {
        this.registry.releaseNodes(nodeRequestID);
        this.nodeProviderJobs.remove(nodeRequestID);
    }

    public void releaseAllNodes() {
        ArrayList<UniqueID> nodeRequestIDs = new ArrayList<UniqueID>(this.nodeProviderJobs.keySet());
        for (UniqueID nodeRequestID : nodeRequestIDs) {
            this.releaseNodes(nodeRequestID);
        }
    }
}

