/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.job.programming;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.objectweb.proactive.core.UniqueID;
import org.objectweb.proactive.core.node.Node;
import org.objectweb.proactive.core.util.log.ProActiveLogger;
import org.ow2.proactive.scheduler.job.programming.NodeProviderTask;

public class NodeRequest {
    private static final Logger logger = ProActiveLogger.getLogger(NodeRequest.class);
    private UniqueID nodeRequestID;
    private int nbNodes;
    private List<NodeProviderTask.NodeProviderTaskHolder> tasks;

    public NodeRequest(UniqueID nodeRequestID, int nbNodes) {
        this.nodeRequestID = nodeRequestID;
        this.nbNodes = nbNodes;
        this.tasks = new ArrayList<NodeProviderTask.NodeProviderTaskHolder>(nbNodes);
    }

    public void addNodeProviderTask(NodeProviderTask.NodeProviderTaskHolder task) {
        if (this.nbNodes > this.tasks.size()) {
            this.tasks.add(task);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Received registration of node provider task for node request #" + this.nodeRequestID));
            }
        } else {
            task.release();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Received registration of node provider task for node request #" + this.nodeRequestID + " but required number of nodes has already been reached"));
            }
        }
    }

    public boolean isDeploymentFinished() {
        return this.tasks.size() == this.nbNodes;
    }

    public List<Node> getNodes() {
        if (!this.isDeploymentFinished()) {
            logger.warn((Object)("Deployment of node request #" + this.nodeRequestID + " is not finished, only " + this.tasks.size() + " of " + this.nbNodes + " tasks are registered"));
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (NodeProviderTask.NodeProviderTaskHolder task : this.tasks) {
            nodes.add(task.getNode());
        }
        return nodes;
    }

    public void releaseNodes() {
        for (NodeProviderTask.NodeProviderTaskHolder task : this.tasks) {
            task.release();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.tasks.size() + " node provider tasks for node request #" + this.nodeRequestID + " have been released"));
        }
        this.tasks.clear();
    }
}

