/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.job.programming;

import java.io.IOException;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.objectweb.proactive.ActiveObjectCreationException;
import org.objectweb.proactive.api.PAActiveObject;
import org.objectweb.proactive.core.UniqueID;
import org.objectweb.proactive.core.node.Node;
import org.objectweb.proactive.core.node.NodeException;
import org.objectweb.proactive.core.util.log.ProActiveLogger;
import org.ow2.proactive.scheduler.common.task.TaskResult;
import org.ow2.proactive.scheduler.common.task.executable.JavaExecutable;
import org.ow2.proactive.scheduler.job.programming.NodeProviderRegistry;

public class NodeProviderTask
extends JavaExecutable {
    private static final Logger logger = ProActiveLogger.getLogger(NodeProviderTask.class);
    private String registryURL;
    private UniqueID nodeRequestID;

    public Serializable execute(TaskResult ... arg0) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Node provider task for node request #" + this.nodeRequestID + " has started"));
        }
        NodeProviderTaskHolder taskHolder = (NodeProviderTaskHolder)PAActiveObject.newActive(NodeProviderTaskHolder.class, (Object[])new Object[]{this.registryURL, this.nodeRequestID}, (Node)PAActiveObject.getNode());
        taskHolder.registerToRegistry();
        while (!taskHolder.isReleased()) {
            Thread.sleep(1000L);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Node provider task for node request #" + this.nodeRequestID + " has terminated"));
        }
        return null;
    }

    public static class NodeProviderTaskHolder {
        private final String registryURL;
        private final UniqueID nodeRequestID;
        private boolean isReleased;

        public NodeProviderTaskHolder() {
            this.registryURL = null;
            this.nodeRequestID = null;
            this.isReleased = false;
        }

        public NodeProviderTaskHolder(String registryURL, UniqueID nodeRequestID) {
            this.registryURL = registryURL;
            this.nodeRequestID = nodeRequestID;
            this.isReleased = false;
        }

        public UniqueID getNodeRequestID() {
            return this.nodeRequestID;
        }

        public boolean isReleased() {
            return this.isReleased;
        }

        public void release() {
            this.isReleased = true;
        }

        public void registerToRegistry() throws ActiveObjectCreationException, IOException {
            NodeProviderRegistry registry = (NodeProviderRegistry)PAActiveObject.lookupActive(NodeProviderRegistry.class, (String)this.registryURL);
            registry.registerNodeProviderTask((NodeProviderTaskHolder)PAActiveObject.getStubOnThis());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Node provider task for node request #" + this.nodeRequestID + " has registered to registry"));
            }
        }

        public Node getNode() {
            try {
                return PAActiveObject.getNode();
            }
            catch (NodeException ne) {
                logger.error((Object)("Unable to get Node for node request #" + this.nodeRequestID + ": " + ne.getMessage()), (Throwable)ne);
                return null;
            }
        }
    }
}

