/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.job.programming;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.objectweb.proactive.api.PAActiveObject;
import org.objectweb.proactive.core.UniqueID;
import org.objectweb.proactive.core.node.Node;
import org.objectweb.proactive.core.util.log.ProActiveLogger;
import org.ow2.proactive.scheduler.job.programming.NodeProviderTask;
import org.ow2.proactive.scheduler.job.programming.NodeRequest;

public class NodeProviderRegistry {
    private static final Logger logger = ProActiveLogger.getLogger(NodeProviderRegistry.class);
    private final Map<UniqueID, NodeRequest> nodeRequests = new HashMap<UniqueID, NodeRequest>();

    public String getURL() {
        return PAActiveObject.getUrl((Object)PAActiveObject.getStubOnThis());
    }

    public void addNodeRequest(UniqueID nodeRequestID, int nbNodes) {
        if (!this.nodeRequests.containsKey(nodeRequestID)) {
            this.nodeRequests.put(nodeRequestID, new NodeRequest(nodeRequestID, nbNodes));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Node request #" + nodeRequestID + " for " + nbNodes + " nodes added"));
            }
        }
    }

    public void registerNodeProviderTask(NodeProviderTask.NodeProviderTaskHolder task) {
        UniqueID nodeRequestID = task.getNodeRequestID();
        if (this.nodeRequests.containsKey(nodeRequestID)) {
            this.nodeRequests.get(nodeRequestID).addNodeProviderTask(task);
        } else {
            task.release();
            logger.error((Object)("Node provider task tried to register to node request #" + nodeRequestID + " but there is no such node request ID"));
        }
    }

    public boolean isDeploymentFinished(UniqueID nodeRequestID) {
        if (this.nodeRequests.containsKey(nodeRequestID)) {
            return this.nodeRequests.get(nodeRequestID).isDeploymentFinished();
        }
        logger.error((Object)("No such node request #" + nodeRequestID));
        return false;
    }

    public List<Node> getNodes(UniqueID nodeRequestID) {
        if (this.nodeRequests.containsKey(nodeRequestID)) {
            return this.nodeRequests.get(nodeRequestID).getNodes();
        }
        logger.error((Object)("No such node request #" + nodeRequestID));
        return null;
    }

    public void releaseNodes(UniqueID nodeRequestID) {
        if (this.nodeRequests.containsKey(nodeRequestID)) {
            this.nodeRequests.remove(nodeRequestID).releaseNodes();
        } else {
            logger.error((Object)("No such node request #" + nodeRequestID));
        }
    }
}

