/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.job.programming;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.objectweb.proactive.core.ProActiveException;
import org.objectweb.proactive.core.UniqueID;
import org.objectweb.proactive.core.util.log.ProActiveLogger;
import org.objectweb.proactive.extensions.vfsprovider.FileSystemServerDeployer;
import org.ow2.proactive.scheduler.common.Scheduler;
import org.ow2.proactive.scheduler.common.exception.JobCreationException;
import org.ow2.proactive.scheduler.common.exception.NotConnectedException;
import org.ow2.proactive.scheduler.common.exception.PermissionException;
import org.ow2.proactive.scheduler.common.exception.SubmissionClosedException;
import org.ow2.proactive.scheduler.common.exception.UserException;
import org.ow2.proactive.scheduler.common.job.Job;
import org.ow2.proactive.scheduler.common.job.JobId;
import org.ow2.proactive.scheduler.common.job.TaskFlowJob;
import org.ow2.proactive.scheduler.common.task.ForkEnvironment;
import org.ow2.proactive.scheduler.common.task.JavaTask;
import org.ow2.proactive.scheduler.common.task.Task;
import org.ow2.proactive.scheduler.job.programming.NodeProviderException;
import org.ow2.proactive.scheduler.job.programming.NodeProviderTask;
import org.ow2.proactive.scripting.InvalidScriptException;
import org.ow2.proactive.scripting.Script;
import org.ow2.proactive.scripting.SelectionScript;
import org.ow2.proactive.scripting.SimpleScript;

public class NodeProviderJob {
    private static final Logger logger = ProActiveLogger.getLogger(NodeProviderJob.class);
    private static final Map<String, FileSystemServerDeployer> fileSystemServers = new HashMap<String, FileSystemServerDeployer>();
    private final UniqueID nodeRequestID;
    private final Scheduler scheduler;
    private final JobId jobID;

    public NodeProviderJob(UniqueID nodeRequestID, Scheduler scheduler, int nbNodes, String dataFolder, List<String> jvmArguments, String registryURL, String ... nodeSourceNames) throws NodeProviderException {
        try {
            this.nodeRequestID = nodeRequestID;
            this.scheduler = scheduler;
            this.jobID = this.scheduler.submit((Job)this.createJob(nbNodes, dataFolder, jvmArguments, registryURL, nodeSourceNames));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Job #" + this.jobID.getReadableName() + " for node request #" + this.nodeRequestID + " has been submitted to the scheduler"));
            }
        }
        catch (IOException ioe) {
            throw new NodeProviderException("Cannot start ProActive dataserver for node request #" + this.nodeRequestID + ": " + ioe.getMessage(), ioe);
        }
        catch (InvalidScriptException ise) {
            throw new NodeProviderException("Cannot create job for node request #" + this.nodeRequestID + ": " + ise.getMessage(), ise);
        }
        catch (UserException ue) {
            throw new NodeProviderException("Cannot create job for node request #" + this.nodeRequestID + ": " + ue.getMessage(), ue);
        }
        catch (NotConnectedException nce) {
            throw new NodeProviderException("Cannot submit job for node request #" + this.nodeRequestID + ": " + nce.getMessage(), nce);
        }
        catch (PermissionException pe) {
            throw new NodeProviderException("Cannot submit job for node request #" + this.nodeRequestID + ": " + pe.getMessage(), pe);
        }
        catch (SubmissionClosedException sce) {
            throw new NodeProviderException("Cannot submit job for node request #" + this.nodeRequestID + ": " + sce.getMessage(), sce);
        }
        catch (JobCreationException jce) {
            throw new NodeProviderException("Cannot submit job for node request #" + this.nodeRequestID + ": " + jce.getMessage(), jce);
        }
    }

    private TaskFlowJob createJob(int nbNodes, String dataFolder, List<String> jvmArguments, String registryURL, String ... nodeSourceNames) throws IOException, InvalidScriptException, UserException {
        TaskFlowJob job = new TaskFlowJob();
        String inputSpaceURL = NodeProviderJob.startFileSystemServer(dataFolder);
        String[] jarNames = this.getJarNames(new File(dataFolder)).toArray(new String[0]);
        job.setName("NodeProviderJob#" + this.nodeRequestID);
        job.setInputSpace(inputSpaceURL);
        for (int i = 0; i < nbNodes; ++i) {
            JavaTask task = new JavaTask();
            task.setName("NodeProviderTask " + (i + 1));
            task.setExecutableClassName(NodeProviderTask.class.getName());
            task.addArgument("registryURL", (Serializable)((Object)registryURL));
            task.addArgument("nodeRequestID", (Serializable)this.nodeRequestID);
            task.setRunAsMe(false);
            if (nodeSourceNames != null) {
                task.setSelectionScript(this.createSelectionScript(nodeSourceNames));
            }
            File addClasspathScriptPath = new File(System.getProperty("scheduler.home") + "/samples/scripts/misc/add_classpath.js");
            ForkEnvironment forkEnvironment = new ForkEnvironment();
            forkEnvironment.setWorkingDir(".");
            forkEnvironment.setEnvScript((Script)new SimpleScript(addClasspathScriptPath, jarNames));
            if (jvmArguments != null) {
                for (String jvmArgument : jvmArguments) {
                    forkEnvironment.addJVMArgument(jvmArgument);
                }
            }
            task.setForkEnvironment(forkEnvironment);
            job.addTask((Task)task);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Job for node request #" + this.nodeRequestID + " has been created"));
        }
        return job;
    }

    private List<String> getJarNames(File currentFile) {
        if (currentFile.isDirectory()) {
            File[] jarFiles;
            File[] folders;
            ArrayList<String> jarNames = new ArrayList<String>();
            for (File folder : folders = currentFile.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            })) {
                List<String> innerJarNames = this.getJarNames(folder);
                for (int i = 0; i < innerJarNames.size(); ++i) {
                    innerJarNames.set(i, folder.getName() + File.separator + innerJarNames.get(i));
                }
                jarNames.addAll(innerJarNames);
            }
            for (File jarFile : jarFiles = currentFile.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            })) {
                jarNames.add(jarFile.getName());
            }
            return jarNames;
        }
        return new ArrayList<String>();
    }

    private SelectionScript createSelectionScript(String ... nodeSourceNames) throws InvalidScriptException {
        String selectionScript;
        if (nodeSourceNames.length > 0) {
            selectionScript = "try { var nodeSourceName = java.lang.System.getProperty('proactive.node.nodesource'); if (";
            for (String nodeSourceName : nodeSourceNames) {
                selectionScript = selectionScript + "nodeSourceName.equals('" + nodeSourceName + "') || ";
            }
            selectionScript = selectionScript + " false) { selected = true; } else { selected = false; } } catch (error) { selected = false; }";
        } else {
            selectionScript = "selected = true;";
        }
        return new SelectionScript(selectionScript, "JavaScript");
    }

    private static synchronized String startFileSystemServer(String dataFolder) throws IOException {
        if (fileSystemServers.containsKey(dataFolder)) {
            return fileSystemServers.get(dataFolder).getVFSRootURL();
        }
        FileSystemServerDeployer fileSystemServer = new FileSystemServerDeployer(dataFolder, true);
        String url = fileSystemServer.getVFSRootURL();
        fileSystemServers.put(dataFolder, fileSystemServer);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ProActive dataserver successfully started. VFS URL of this provider: " + url));
        }
        return url;
    }

    private static synchronized void stopFileSystemServer(String dataFolder) {
        if (fileSystemServers.containsKey(dataFolder)) {
            FileSystemServerDeployer fileSystemServer = fileSystemServers.get(dataFolder);
            try {
                fileSystemServer.terminate();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("ProActive dataserver at " + fileSystemServer.getVFSRootURL() + " has been terminated"));
                }
            }
            catch (ProActiveException pae) {
                logger.error((Object)("Cannot properly terminate ProActive dataserver at " + fileSystemServer.getVFSRootURL() + ": " + pae.getMessage()), (Throwable)pae);
            }
        }
    }

    private static void stopAllFileSystemServers() {
        for (String dataFolder : fileSystemServers.keySet()) {
            NodeProviderJob.stopFileSystemServer(dataFolder);
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                NodeProviderJob.stopAllFileSystemServers();
            }
        });
    }
}

