/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.soap;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.petalslink.dsb.soap.api.Service;
import org.petalslink.dsb.soap.api.ServiceException;
import org.petalslink.dsb.soap.api.SimpleExchange;

public abstract class AbstractService
implements Service {
    private static Logger logger = Logger.getLogger(AbstractService.class.getName());
    protected QName interfaceName;
    protected QName serviceName;
    protected QName endpointName;
    protected String wsdl;
    protected String url;

    public AbstractService(QName interfaceName, QName serviceName, QName endpointName, String wsdl, String url) {
        this.interfaceName = interfaceName;
        this.serviceName = serviceName;
        this.endpointName = endpointName;
        this.wsdl = wsdl;
        this.url = url;
    }

    public String getWSDLURL() {
        return this.wsdl;
    }

    public String getURL() {
        return this.url;
    }

    public QName getEndpoint() {
        return this.endpointName;
    }

    public QName getInterface() {
        return this.interfaceName;
    }

    public QName getService() {
        return this.serviceName;
    }

    public final void invoke(SimpleExchange exchange) throws ServiceException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Got an invoke on service");
        }
        if (exchange == null) {
            String message = "Exchange is null and should not...";
            logger.warning("Exchange is null and should not...");
            throw new ServiceException("Exchange is null and should not...");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Operation is " + exchange.getOperation());
        }
        this.pre(exchange);
        this.doInvoke(exchange);
        this.post(exchange);
    }

    protected void post(SimpleExchange exchange) throws ServiceException {
    }

    protected abstract void doInvoke(SimpleExchange var1) throws ServiceException;

    protected void pre(SimpleExchange exchange) throws ServiceException {
    }
}

