/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.service.client.saaj;

import javax.xml.namespace.QName;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.petalslink.dsb.saaj.utils.SOAPMessageUtils;
import org.petalslink.dsb.service.client.ClientException;
import org.petalslink.dsb.service.client.Message;
import org.petalslink.dsb.service.client.MessageImpl;
import org.petalslink.dsb.service.client.MessageListener;
import org.w3c.dom.Document;

public class Client
implements org.petalslink.dsb.service.client.Client {
    public void fireAndForget(Message message) throws ClientException {
        throw new ClientException("Not implemented");
    }

    public Message sendReceive(Message message) throws ClientException {
        MessageImpl result = null;
        if (message == null) {
            throw new ClientException("Message can not be null...");
        }
        QName operation = message.getOperation();
        if (operation == null) {
            throw new ClientException("Operation can not be null...");
        }
        try {
            SOAPMessage request = SOAPMessageUtils.createSOAPMessageFromBodyContent((Document)message.getPayload());
            MimeHeaders hd = request.getMimeHeaders();
            hd.addHeader("SOAPAction", operation.getLocalPart());
            SOAPConnectionFactory soapConnFactory = SOAPConnectionFactory.newInstance();
            SOAPConnection connection = soapConnFactory.createConnection();
            SOAPMessage response = connection.call(request, (Object)message.getEndpoint());
            result = new MessageImpl();
            if (response != null) {
                result.setPayload(SOAPMessageUtils.getBodyFromMessage((SOAPMessage)response));
            }
        }
        catch (UnsupportedOperationException e) {
            throw new ClientException((Throwable)e);
        }
        catch (SOAPException e) {
            throw new ClientException((Throwable)e);
        }
        return result;
    }

    public void sendAsync(Message message, MessageListener listener) throws ClientException {
        throw new ClientException("Not implemented");
    }

    public String getName() {
        return "SAAJClient";
    }
}

