/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.notification.commons;

import com.ebmwebsourcing.wsaddressing10.api.type.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.engines.NotificationProducerEngine;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.petalslink.dsb.notification.commons.NotificationException;
import org.petalslink.dsb.notification.commons.NotificationHelper;
import org.petalslink.dsb.notification.commons.api.NotificationSender;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractNotificationSender
implements NotificationSender {
    private static final Logger log = Logger.getLogger(AbstractNotificationSender.class.getName());
    private NotificationProducerEngine producer;
    private DocumentBuilderFactory documentFactory;

    public AbstractNotificationSender(NotificationProducerEngine producer) {
        this.producer = producer;
        this.documentFactory = DocumentBuilderFactory.newInstance();
        this.documentFactory.setNamespaceAware(true);
    }

    public void notify(Notify notify) throws NotificationException {
        List messages = notify.getNotificationMessage();
        for (NotificationMessageHolderType notificationMessageHolderType : messages) {
            TopicExpressionType topic = notificationMessageHolderType.getTopic();
            String topicContent = topic.getContent();
            String prefix = null;
            String localPart = null;
            if (topicContent.contains(":")) {
                prefix = topicContent.substring(0, topicContent.indexOf(":"));
                localPart = topicContent.substring(topicContent.indexOf(":") + 1);
            }
            String ns = null;
            if (prefix != null && topic.getTopicNamespaces() != null) {
                boolean found = false;
                Iterator iter = topic.getTopicNamespaces().iterator();
                while (iter.hasNext() && !found) {
                    QName qname = (QName)iter.next();
                    if (!prefix.equals(qname.getLocalPart())) continue;
                    ns = qname.getNamespaceURI();
                    found = true;
                }
            }
            QName topicName = new QName(ns, localPart, prefix);
            Element element = notificationMessageHolderType.getMessage().getAny();
            Document dom = null;
            if (element != null) {
                dom = element.getOwnerDocument();
            }
            String dialect = topic.getDialect().toString();
            this.notify(dom, topicName, dialect);
        }
    }

    public void notify(Document payload, QName topic, String dialect) throws NotificationException {
        String endpointNameAddress = null;
        try {
            List uuids = this.producer.getSubsMgr().getStoredSubscriptionUuids();
            TopicExpressionType exp = NotificationHelper.createTopicExpression(topic, dialect);
            boolean setCurrentMessage = false;
            for (String subscriptionId : uuids) {
                List topicExps = this.producer.getSubsMgr().getTopicExpressionOfSubscription(subscriptionId);
                if (topicExps == null) continue;
                for (TopicExpressionType topicExp : topicExps) {
                    EndpointReferenceType currentConsumerEdp;
                    String expS;
                    String topicExpS;
                    if (topicExp == null || !(topicExpS = topicExp.getContent().substring(topicExp.getContent().indexOf(":") + 1)).equals(expS = exp.getContent().substring(exp.getContent().indexOf(":") + 1)) || (currentConsumerEdp = this.producer.getSubsMgr().getConsumerEdpRefOfSubscription(subscriptionId)) == null) continue;
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("currentConsumerEdp.getAddress().getValue() = " + currentConsumerEdp.getAddress().getValue());
                    }
                    endpointNameAddress = currentConsumerEdp.getAddress().getValue().toString().indexOf("::") > 0 ? "{" + currentConsumerEdp.getAddress().getValue().toString().split("::")[0] + "}" + currentConsumerEdp.getAddress().getValue().toString().split("::")[1] : currentConsumerEdp.getAddress().getValue().toString();
                    String producerAddress = this.getProducerAddress();
                    Notify notify = NotificationHelper.createNotification(producerAddress, currentConsumerEdp.getAddress().getValue().toString(), subscriptionId, topic, dialect, payload);
                    this.producer.setCurrentMessage(NotificationHelper.createTopicExpression(topic, dialect), ((NotificationMessageHolderType)notify.getNotificationMessage().get(0)).getMessage(), false);
                    setCurrentMessage = true;
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(String.format("Sending notify to %s", currentConsumerEdp.getAddress().getValue().toString()));
                    }
                    try {
                        this.doNotify(notify, producerAddress, currentConsumerEdp, subscriptionId, topic, dialect);
                    }
                    catch (NotificationException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (setCurrentMessage) {
                String producerAddress = this.getProducerAddress();
                Notify notify = NotificationHelper.createNotification(producerAddress, null, null, topic, dialect, payload);
                this.producer.setCurrentMessage(NotificationHelper.createTopicExpression(topic, dialect), ((NotificationMessageHolderType)notify.getNotificationMessage().get(0)).getMessage(), false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.severe("Impossible to send notification to " + endpointNameAddress + " : " + e.getMessage());
        }
    }

    protected abstract void doNotify(Notify var1, String var2, EndpointReferenceType var3, String var4, QName var5, String var6) throws NotificationException;

    protected abstract String getProducerAddress();
}

