/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.wrapper.printwriter;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Handler;
import org.objectweb.util.monolog.api.Level;
import org.objectweb.util.monolog.api.LevelFactory;
import org.objectweb.util.monolog.api.LogInfo;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.MonologFactory;
import org.objectweb.util.monolog.api.MonologFactoryListener;
import org.objectweb.util.monolog.api.TopicalLogger;
import org.objectweb.util.monolog.wrapper.common.EnumrationImpl;
import org.objectweb.util.monolog.wrapper.common.LevelImpl;

public class LoggerImpl
implements TopicalLogger,
MonologFactory {
    public static final String PRINT_WRITER = "printwriter";
    private int level = BasicLevel.DEBUG;
    private Level lev = null;
    protected String name = null;
    protected Vector topics = null;
    protected Hashtable handlers = null;
    protected boolean additivity = true;
    protected Map levels = null;
    private PrintWriter pw = null;
    private boolean isOn = true;

    public LoggerImpl() {
        this(null);
    }

    public LoggerImpl(PrintWriter _pw) {
        this("org.objectweb.util.monolog.wrapper.printwriter", _pw);
    }

    public LoggerImpl(String n, PrintWriter _pw) {
        this.name = n;
        this.pw = _pw;
    }

    public PrintWriter getPrintWriter() {
        return this.pw;
    }

    public void addMonologFactoryListener(MonologFactoryListener mfl) {
    }

    public void removeMonologFactoryListener(MonologFactoryListener mfl) {
    }

    public void configure(Properties prop) throws Exception {
    }

    public Handler createHandler(String hn, String handlertype) {
        return this;
    }

    public Handler removeHandler(String handlername) {
        return this;
    }

    public Handler[] getHandlers() {
        return new Handler[]{this};
    }

    public synchronized Level defineLevel(String name, int value) {
        LevelImpl l = new LevelImpl(name, value);
        if (this.levels == null) {
            this.levels = new HashMap();
        }
        this.levels.put(new Integer(value), l);
        return l;
    }

    public Level defineLevel(String name, String value) {
        LevelImpl l = new LevelImpl(name, value, (LevelFactory)this);
        if (this.levels == null) {
            this.levels = new HashMap();
        }
        this.levels.put(new Integer(value), l);
        return l;
    }

    public Level getLevel(String name) {
        for (Level l : this.levels.values()) {
            if (!l.getName().equals(name)) continue;
            return l;
        }
        return null;
    }

    public Level getLevel(int value) {
        return (Level)this.levels.get(new Integer(value));
    }

    public Level[] getLevels() {
        return this.levels.values().toArray(new Level[this.levels.size()]);
    }

    public synchronized void removeLevel(String name) {
        Iterator it = this.levels.values().iterator();
        while (it.hasNext()) {
            Level l = (Level)it.next();
            if (!l.getName().equals(name)) continue;
            it.remove();
        }
    }

    public Logger getLogger(String key) {
        return this;
    }

    public Logger getLogger(String key, String resourceBundleName) {
        return this;
    }

    public String getResourceBundleName() {
        return null;
    }

    public void setResourceBundleName(String resourceBundleName) {
    }

    public Logger[] getLoggers() {
        return new Logger[]{this};
    }

    public String getTopicPrefix() {
        return null;
    }

    public void setIntLevel(int l) {
        this.level = l;
    }

    public void setLevel(Level l) {
        this.lev = l;
        if (this.lev != null) {
            this.level = this.lev.getIntValue();
        }
    }

    public int getCurrentIntLevel() {
        return this.level;
    }

    public Level getCurrentLevel() {
        return this.lev == null ? (this.lev = new LevelImpl(this.level == -1 ? "INHERIT" : "INTER", this.level)) : this.lev;
    }

    public boolean isLoggable(int l) {
        return this.pw != null && l >= this.level;
    }

    public boolean isLoggable(Level l) {
        return this.pw != null && l != null && l.getIntValue() >= this.level;
    }

    public boolean isOn() {
        return this.isOn;
    }

    public Enumeration getTopics() {
        if (this.topics == null) {
            Object[] ar = new String[]{this.name};
            return new EnumrationImpl(ar);
        }
        Object[] str = new String[this.topics.size()];
        for (int i = 0; i < this.topics.size(); ++i) {
            str[i] = (String)this.topics.elementAt(i);
        }
        return new EnumrationImpl(str);
    }

    public void log(int level, Object o) {
        if (this.pw == null || !this.isOn() || o == null || !this.isLoggable(level)) {
            return;
        }
        if (level == BasicLevel.ERROR) {
            this.pw.println("**" + LoggerImpl.format(o.toString(), 2));
        } else {
            this.pw.println(LoggerImpl.format(o.toString(), 2));
        }
    }

    public void log(Level l, Object o) {
    }

    public void log(int level, Object o, Throwable t) {
        if (this.pw == null || !this.isOn() || o == null || !this.isLoggable(level)) {
            return;
        }
        this.pw.println(o.toString() + ":" + t.toString());
    }

    public void log(Level l, Object o, Throwable t) {
    }

    public void log(int level, Object o, Object location, Object method) {
        if (this.pw == null || !this.isOn() || o == null || !this.isLoggable(level)) {
            return;
        }
        this.pw.println(location.toString() + "." + method.toString() + "(...) :" + o.toString());
    }

    public void log(Level l, Object o, Object location, Object method) {
    }

    public void log(int level, Object o, Throwable t, Object location, Object method) {
        if (this.pw == null || !this.isOn() || o == null || !this.isLoggable(level)) {
            return;
        }
        this.pw.println(location.toString() + "." + method.toString() + "(...) :" + o.toString() + " " + t.toString());
    }

    public void log(Level l, Object o, Throwable t, Object location, Object method) {
    }

    public void turnOn() {
        this.isOn = true;
    }

    public void turnOff() {
        this.isOn = false;
    }

    public String toString() {
        return "Personnal implementation on PrintWriter object";
    }

    public void addHandler(Handler h) throws Exception {
        if (h != null) {
            if (this.handlers == null) {
                this.handlers = new Hashtable();
            }
            this.handlers.put(h.getName(), h);
        }
    }

    public void addTopic(String topic) throws Exception {
        if (this.topics == null) {
            this.topics = new Vector();
            this.topics.addElement(this.name);
        }
        this.topics.addElement(topic);
    }

    public void removeHandler(Handler h) throws Exception {
        if (h != null && this.handlers != null) {
            this.handlers.remove(h.getName());
        }
    }

    public void removeAllHandlers() throws Exception {
        if (this.handlers != null) {
            this.handlers.clear();
        }
    }

    public void removeTopic(String topic) throws Exception {
        if (this.topics != null) {
            this.topics.removeElement(topic);
        }
    }

    public void setAdditivity(boolean a) {
        this.additivity = a;
    }

    public boolean getAdditivity() {
        return this.additivity;
    }

    public Handler[] getHandler() {
        Handler[] result;
        if (this.handlers == null) {
            result = new Handler[]{};
        } else {
            result = new Handler[this.handlers.size()];
            int i = 0;
            Enumeration e = this.handlers.elements();
            while (e.hasMoreElements()) {
                result[i] = (Handler)e.nextElement();
                ++i;
            }
        }
        return result;
    }

    public Handler getHandler(String hn) {
        return this.handlers == null ? null : (Handler)this.handlers.get(hn);
    }

    public String[] getTopic() {
        if (this.topics == null) {
            String[] ar = new String[]{this.name};
            return ar;
        }
        String[] str = new String[this.topics.size()];
        for (int i = 0; i < this.topics.size(); ++i) {
            str[i] = (String)this.topics.elementAt(i);
        }
        return str;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getType() {
        return "logger";
    }

    public String[] getAttributeNames() {
        String[] ar = new String[]{PRINT_WRITER};
        return ar;
    }

    public Object getAttribute(String name) {
        if (PRINT_WRITER.equalsIgnoreCase(name)) {
            return this.pw;
        }
        return null;
    }

    public Object setAttribute(String name, Object value) {
        if (PRINT_WRITER.equalsIgnoreCase(name) && value != null && value instanceof PrintWriter) {
            this.pw = (PrintWriter)value;
        }
        return null;
    }

    public static String format(String msg, int removeTopStack) {
        Throwable t = new Throwable().fillInStackTrace();
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        String m = sw.getBuffer().toString();
        int deb = -1;
        int fin = 0;
        deb = -1;
        for (int i = 0; i < removeTopStack + 1; ++i) {
            deb = m.indexOf("\n", deb + 1);
        }
        deb = m.indexOf("at ", deb);
        fin = m.indexOf("\n", deb);
        m = m.substring(deb + 3, fin);
        deb = m.indexOf("(");
        fin = m.indexOf(":");
        m = m.substring(0, deb + 1) + m.substring(fin + 1, m.length());
        deb = m.indexOf("(");
        int c1 = 0;
        int c2 = 0;
        int current = m.indexOf(".");
        while (current != -1 && current < deb) {
            c1 = c2;
            c2 = current;
            current = m.indexOf(".", current + 1);
        }
        m = m.substring(c1 + 1, m.length());
        return m + ": " + msg;
    }

    public void addLogInfo(Character pattern, LogInfo logInfoProvider) {
    }

    public void removeLogInfo(char pattern) {
    }

    public LogInfo getLogInfo(Character pattern) {
        return null;
    }

    static {
        if (BasicLevel.FATAL <= 0 || BasicLevel.ERROR <= 0 || BasicLevel.WARN <= 0 || BasicLevel.INFO <= 0 || BasicLevel.DEBUG <= 0) {
            BasicLevel.FATAL = 50000;
            BasicLevel.ERROR = 40000;
            BasicLevel.WARN = 30000;
            BasicLevel.INFO = 20000;
            BasicLevel.DEBUG = 10000;
        }
    }
}

