/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.objectweb.util.monolog.api.HandlerFactory;
import org.objectweb.util.monolog.api.LevelFactory;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.objectweb.util.monolog.api.MonologFactory;
import org.objectweb.util.monolog.file.monolog.PropertiesConfAccess;
import org.objectweb.util.monolog.wrapper.printwriter.LoggerImpl;

public class Monolog {
    public static boolean debug = new Boolean(System.getProperty("monolog.debug"));
    private static MonologFactory basicMonologFactory;
    public static MonologFactory monologFactory;
    public static LoggerFactory loggerFactory;
    public static final String DEFAULT_MONOLOG_FILE = "monolog.properties";
    public static final String MONOLOG_FILE_NAME = "monolog.filename";
    public static final String MONOLOG_CLASS_NAME = "monolog.classname";
    public static final String LOG4J_WRAPPER_CLASS_NAME = "org.objectweb.util.monolog.wrapper.log4j.MonologLoggerFactory";
    public static final String LOG4JMini_WRAPPER_CLASS_NAME = "org.objectweb.util.monolog.wrapper.log4jMini.MonologLoggerFactory";
    public static final String JDK_WRAPPER_CLASS_NAME = "org.objectweb.util.monolog.wrapper.javaLog.LoggerFactory";
    private static final String LOG4J_CLASS_NAME = "org.apache.log4j.Logger";
    private static final String LOG4JMini_CLASS_NAME = "org.apache.log4j.Category";
    private static final String JDK_CLASS_NAME = "java.util.logging.Logger";

    public static MonologFactory getMonologFactory() {
        return monologFactory;
    }

    public static MonologFactory getDefaultMonologFactory() {
        return basicMonologFactory;
    }

    public static MonologFactory initialize() {
        if (monologFactory == basicMonologFactory) {
            Monolog.getMonologFactory(System.getProperty(MONOLOG_FILE_NAME, DEFAULT_MONOLOG_FILE));
        }
        return monologFactory;
    }

    public static LoggerFactory init() {
        return Monolog.initialize();
    }

    public static LoggerFactory init(String fileName) {
        return Monolog.getMonologFactory(fileName);
    }

    public static MonologFactory getMonologFactory(String fileName) {
        Monolog.debug("DEBUG: debug is activated!");
        File f = new File(fileName);
        InputStream is = null;
        if (f.exists()) {
            Monolog.debug("DEBUG: The file " + fileName + " was found from the file system.");
            try {
                is = new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                Monolog.debug("ERROR: " + e.getMessage());
                is = null;
            }
        } else {
            is = Monolog.class.getClassLoader().getResourceAsStream(fileName);
            if (is != null) {
                Monolog.debug("DEBUG: The file " + fileName + " was found from the classpath.");
            }
        }
        if (is != null) {
            Properties p;
            block9: {
                p = new Properties();
                try {
                    p.load(is);
                }
                catch (IOException e) {
                    Monolog.debug("ERROR: problem to load properties from the input stream " + is);
                    if (!debug) break block9;
                    e.printStackTrace(System.out);
                }
            }
            Monolog.getMonologFactory(p);
        } else {
            Monolog.debug("DEBUG: The file " + fileName + " was not found.");
            monologFactory = Monolog.instanciateMonologFactory(null);
        }
        return monologFactory;
    }

    public static MonologFactory getMonologFactory(Properties properties) {
        monologFactory = Monolog.instanciateMonologFactory(properties.getProperty(MONOLOG_CLASS_NAME, System.getProperty(MONOLOG_CLASS_NAME)));
        if (monologFactory != basicMonologFactory) {
            Monolog.loadMonologConfiguration(properties, monologFactory);
        }
        return monologFactory;
    }

    public static LoggerFactory init(Properties properties) {
        return Monolog.getMonologFactory(properties);
    }

    public static void loadMonologConfiguration(Properties properties) {
        Monolog.loadMonologConfiguration(properties, monologFactory);
    }

    public static void loadMonologConfiguration(Properties properties, MonologFactory mf) {
        try {
            PropertiesConfAccess.load(properties, (LoggerFactory)mf, (HandlerFactory)mf, (LevelFactory)mf);
        }
        catch (Exception e) {
            Monolog.error("WARN: problem to configure a loggerFactory:" + e.getMessage(), e);
        }
    }

    public static void loadMonologConfiguration(Properties properties, LoggerFactory lf) {
        Monolog.loadMonologConfiguration(properties, (MonologFactory)lf);
    }

    public static LoggerFactory getLoggerFactory(String className) {
        return Monolog.getMonologFactory(className);
    }

    public static LevelFactory getLevelFactory(String className) {
        return Monolog.getMonologFactory(className);
    }

    public static HandlerFactory getHandlerFactory(String className) {
        return Monolog.getMonologFactory(className);
    }

    public static MonologFactory instanciateMonologFactory(String className) {
        if (className != null) {
            try {
                Monolog.debug("DEBUG: try to use the logger factory: " + className);
                return (MonologFactory)Class.forName(className).newInstance();
            }
            catch (ClassNotFoundException e) {
                Monolog.debug("WARN: The class " + className + " was not found.");
            }
            catch (Exception e) {
                Monolog.debug("WARN: The class " + className + " has no public empty constructor.");
            }
        }
        try {
            Monolog.debug("DEBUG: try to use log4j");
            Class.forName(LOG4J_CLASS_NAME);
            return (MonologFactory)Class.forName(LOG4J_WRAPPER_CLASS_NAME).newInstance();
        }
        catch (Exception e) {
            Monolog.debug("DEBUG: log4j and its wrapper are not availlable:" + e.getMessage());
            if (debug) {
                e.printStackTrace(System.out);
            }
            try {
                Monolog.debug("DEBUG: try to use the jdk");
                Class.forName(JDK_CLASS_NAME);
                return (MonologFactory)Class.forName(JDK_WRAPPER_CLASS_NAME).newInstance();
            }
            catch (Exception e2) {
                Monolog.debug("DEBUG: java.util.logging and its wrapper are not availlable:" + e2.getMessage());
                if (debug) {
                    e2.printStackTrace(System.out);
                }
                try {
                    Monolog.debug("DEBUG: try to use the log4j mini");
                    Class.forName(LOG4JMini_CLASS_NAME);
                    return (MonologFactory)Class.forName(LOG4JMini_WRAPPER_CLASS_NAME).newInstance();
                }
                catch (Exception e3) {
                    Monolog.debug("DEBUG: log4jMini and its wrapper are not availlable:" + e3.getMessage());
                    if (debug) {
                        e3.printStackTrace(System.out);
                    }
                    Monolog.debug("DEBUG: return the basic logger factory");
                    return basicMonologFactory;
                }
            }
        }
    }

    public static void debug(String m) {
        if (debug) {
            System.out.println(m);
        }
    }

    public static void error(String m, Exception e) {
        System.err.println(m);
        if (debug) {
            e.printStackTrace(System.err);
        }
    }

    static {
        monologFactory = basicMonologFactory = new LoggerImpl();
        loggerFactory = monologFactory;
    }
}

