/**
 * Copyright (C) 2004 France Telecom R&D
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.objectweb.util.monolog.wrapper.common;

import java.io.IOException;
import java.io.OutputStream;

/**
 * This Outstream implementation permits to switch the outStream at any time.
 * It is interesting to switch between System.out and System.err dependeing on
 * the message level.
 *
 * @author S.Chassande-Barrioz
 */
public class OutputStreamSwitcher extends OutputStream {

	protected OutputStream currentOut;

	public OutputStreamSwitcher() {
		currentOut = System.out;
	}

	public OutputStreamSwitcher(OutputStream defaultOut) {
		this.currentOut = defaultOut;
	}

	public void switchOutput(OutputStream newOut) {
		currentOut = newOut;
	}

	public void write(byte b[]) throws IOException {
		currentOut.write(b);
	}

	public void write(byte b[], int off, int len) throws IOException {
		currentOut.write(b, off, len);
	}

	public void write(int b) throws IOException {
		currentOut.write(b);
	}

	public void flush() throws IOException {
		currentOut.flush();
	}

	public void close() throws IOException {
	}
}
