/**
 * Copyright (C) 2001-2003 France Telecom R&D
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.objectweb.util.monolog.wrapper.common;

import org.objectweb.util.monolog.api.LoggerFactory;

/**
 * This static class is only used to reference one LoggerFactory instance.
 *
 * @author Sebastien Chassande-Barrioz
 */
public class LoggerFactorySingleton {

	static private LoggerFactory lf = null;

	static public LoggerFactory getLoggerFactory(String classname)
		throws ClassNotFoundException, InstantiationException,
		IllegalAccessException {

		if (lf == null) {
			lf = (LoggerFactory) Class.forName(classname).newInstance();
		}
		return lf;
	}
}
