/**
 * Copyright (C) 2001-2003 France Telecom R&D
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.objectweb.util.monolog.file;

/**
 *
 * @author Sebastien Chassande-Barrioz
 */
public class DottedStringTools {
	public static String getLast(String dottedName) {
		if (dottedName==null)
			return null;
		int pos = dottedName.lastIndexOf('.');
		if (pos == -1)
			return dottedName;
		pos++;
		if (pos==dottedName.length())
			return "";
		return dottedName.substring(pos, dottedName.length());
	}

	public static String getEnd(String dottedName) {
		if (dottedName==null)
			return null;
		int pos = dottedName.indexOf('.');
		if (pos == -1)
			return dottedName;
		pos++;
		if (pos==0)
			return "";
		return dottedName.substring(pos, dottedName.length());
	}

	public static String getBegin(String dottedName) {
		if (dottedName==null)
			return null;
		int pos = dottedName.lastIndexOf('.');
		if (pos == -1)
			return dottedName;
		return dottedName.substring(0, pos);
	}

	public static String getFirst(String dottedName) {
		if (dottedName==null)
			return null;
		int pos = dottedName.indexOf('.');
		if (pos == -1)
			return dottedName;
		return dottedName.substring(0, pos);
	}
}
