/**
 * Copyright (C) 2001-2003 France Telecom R&D
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.objectweb.util.monolog.file.api;

/**
 * This interface decribes the special characters used to describe a pattern.
 * All special characters must be prefix by '%'. Here is an example of
 * pattern: <br/>
 * %l %t %m%n <br/>
 * This pattern will print on a single line the level, the topic name and the
 * message.
 *
 * @author Sebastien Chassande-Barrioz
 */
public interface Pattern {

	/**
	 * This character represents the level name of the message
	 */
	char LEVEL 			= 'l';

	/**
	 * This character represents the topic of the logger
	 */
	char TOPIC 			= 't';

	/**
	 * This character represents the date where the message has been logged
	 */
	char DATE 			= 'd';

	/**
	 * The theard name which has logged the message.
	 */
	char THREAD			= 'h';

	/**
	 * The message which has been logged
	 */
	char MESSAGE 		= 'm';

	/**
	 * This character represents the method in which the log method was called.
	 * Generating caller location information is extremly slow.
	 */
	char METHOD 		= 'M';

	/**
	 * This character represents the class name in which the log method was
	 * called. Generating caller location information is extremly slow.
	 */
	char OBJECT 		= 'O';

	/**
	 * This character represents the line number in the source code where the
	 * log method was called. Generating caller location information is
	 * extremly slow.
	 */
	char LINE_NUMBER	= 'L';

	/**
	 * This character is the prefix of all special character
	 */
	char PREFIX			= '%';

	/**
	 * This character represents a new line.
	 */
	char NEW_LINE		= 'n';

    /**
     * Possible tokens
     */
    char[] TOKENS = {LEVEL, TOPIC, DATE, THREAD, MESSAGE, METHOD, OBJECT, LINE_NUMBER, PREFIX, NEW_LINE};
}
