/**
 * Copyright (C) 2001-2003 France Telecom R&D
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.objectweb.util.monolog.api;

/**
 * It manages Level instances.
 *
 * @author Sebastien Chassande-Barrioz
 */
public interface LevelFactory {

	/**
	 * It defines a new Level with a name and an integer value.
	 * @param name is the name of the new level
	 * @param value is the integer value of the new level
	 * @return a Level instance or a null value if It exists a Level with the
	 * same name but with another integer value.
	 */
	Level defineLevel(String name, int value);

	/**
	 * It defines a new Level with a name and a string value. The string value
	 * is analyzed to obtain the integer value.
	 * @param name is the name of the new level
	 * @param value is the string value of the new level
	 * @return a Level instance or a null value if It exists a Level with the
	 * same name but with another integer value.
	 */
	Level defineLevel(String name, String value);

	/**
	 * It retrieves a Level instance which the name is equals to the parameter.
	 * @param name is the name of request Level
	 * @return a Leve instance or a null value if the level does not exist.
	 */
	Level getLevel(String name);

	/**
	 * It retrieves a Level instance which the integer value is equals to the
	 * parameter.
	 * @param value is the integer value of request Level
	 * @return a Leve instance or a null value if the level does not exist. As
	 * it is possible to define several Levels which have the same integer value
	 * this methods returns the Level instance of first name found in the list.
	 */
	Level getLevel(int value);

	/**
	 * It retrieves all Level instances defined in this manager.
	 */
	Level[] getLevels();

	/**
	 * It removes a Level instance to this manager.
	 */
	void removeLevel(String name);

}
